<?php

namespace App\Traits;

use Browser;
use Illuminate\Support\Carbon;
use App\Models\Admin\UserLoginHistory;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Models\Activity;
use Torann\GeoIP\Facades\GeoIP;
use Torann\GeoIP\Support\HttpClient;
use Torann\GeoIP\Services\AbstractService;
trait LoginTrait
{
    public function LoginTrait()
    {
		// dd('test');
        if(Auth::user()):
            // dd('test');
            if(request()->path() == 'logout'):
                
                activity('User Logged out')
                ->tap(function (Activity $activity) {
                    $activity->route_link = request()->path();
                })->log(Auth::user()->name . " User logged Out 234" );
            endif;
            if (request()->path() == 'home') :
                
                activity('User Logged in')
                ->tap(function (Activity $activity) {
                    $activity->route_link = request()->path();
                })
                    ->log(Auth::user()->name . " User Logged in");
                $userLocation = geoip()->getLocation();

                $data = [
                    'user_id' => Auth::user()->id,
                    'browser' => Browser::browserName(),
                    'operating_system' => Browser::platformName(),
                    'device_family' => Browser::deviceFamily(),
                    'device_model' => Browser::deviceModel(),
                    'user_ip' => geoip()->getClientIP(),
                    'country' => $userLocation['attributes']['country'],
                    'city' => $userLocation['attributes']['city'],
                    'state' => $userLocation['attributes']['state'],
                    'state_name' => $userLocation['attributes']['state_name'],
                    'postal_code' => $userLocation['attributes']['postal_code'],
                    'lat' => $userLocation['attributes']['lat'],
                    'long' => $userLocation['attributes']['lon'],
                    'timezone' => $userLocation['attributes']['timezone'],
                    'continent' => $userLocation['attributes']['continent'],
                    'currency' => $userLocation['attributes']['currency'],
                    'iso_code' => $userLocation['attributes']['iso_code'],
                    'created_at' => Carbon::now(),
                ];
				
                UserLoginHistory::insert($data);

            endif;
        endif;
    }
	
}
