<?php

namespace App\Traits;

use App\Http\Controllers\Admin\LanguageFiles;

trait ApiLanguageTrait
{
    public function __transEn($word)
    {

        return $this->getTranslation($word,'en');
    }

    public function __transAr($word)
    {

        return $this->getTranslation($word, 'ar');
    }

    public function getTranslation($word,$abbr)
    {
        $filePath =  base_path("resources/lang/".$abbr."/api.php");
        if (is_file($filePath)) {
            $wordsArray = include $filePath;
        }

        return isset($wordsArray[$word]) ? $wordsArray[$word] : $word;
    }
}
