<?php

namespace App\Models\Project;
use App\Models\Admin\User;
use App\Models\Project\Item;
use App\Models\Project\Vendor_slider;
use App\Models\Project\VendorType;
use App\Models\Project\Vendor_item_Category;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Vendor_detail extends Model
{
    use HasFactory;

    protected $fillable = [
        '*'
    ];
    public function vender_type()
    {
      return  $this->belongsTo(VendorType::class,'vendor_type_id','id');
    }

    public function user()
    {
        return  $this->belongsTo(user::class,'user_id','id');
    }


    public function item_category()
    {
        return $this->hasMany(Vendor_item_Category::class, 'id', 'vendor_id');
    }

    public function items()
    {
        return $this->hasMany(Item::class, 'vendor_id', 'id');
    }

    public function slider()
    {
        return $this->hasMany(Vendor_slider::class, 'vendor_id', 'id');
    }

    public function ratings()
    {
        return $this->hasMany(Review::class,'vendor_id');
    }

    public function offers()
    {
        return $this->hasMany(Coupon::class, 'vendor_id');
    }

}
