<?php

namespace App\Models\Project;

use App\Models\Project\Category;
use App\Models\Project\Vendor_detail;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class VendorType extends Model
{
    use HasFactory;

    protected $fillable = ['*'];
    
    // edit not working because of this array
    // protected $casts = [
    //     'name_en' => 'array',
    //     'description_en' => 'array',
    //     'name_ar' => 'array',
    //     'description_ar' => 'array',
    // ];

    public function vender_details()
    {
        return $this->hasMany(Vendor_detail::class, 'vendor_type_id','id');
    }

    public function vender_categories()
    {
        return $this->hasMany(Category::class);
    }

    public function promotion_slider()
    {
        return $this->hasMany(Promotion_slider::class, 'vendor_id', 'id');
    }
    public function categories()
    {
        return $this->hasMany(Category::class);
    }
}
