<?php

namespace App\Models\Project;

use App\Models\Admin\User;
use App\Models\Project\Order_detail;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Order extends Model
{
    use HasFactory;
    protected $fillable  = ['*'];

    public function order_details()
    {
        return $this->hasMany(Order_detail::class);
    }

    public function customer()
    {
        return $this->belongsTo(User::class,'user_id','id');
    }

    public function items()
    {
        return $this->belongsTo(Item::class,'item_id','id');
    }

    public function tables()
    {
        return $this->belongsTo(Table::class,'table_id','id');
    }

    public function vendor()
    {
        return $this->belongsTo(Vendor_detail::class,'vendor_id','id');
    }

    public function timings()
    {
        return $this->belongsTo(Vendor_timing::class,'time_id','id');
    }

    public function ratings()
    {
        return $this->hasOne(Review::class);
    }
}
