<?php

namespace App\Models\Project;

use App\Models\Project\Wishlist;
use App\Models\Project\VendorType;
use App\Models\Project\Item_gallery;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Item extends Model
{
    use HasFactory;
    protected $fillable = ['status','item_name_en','item_description_en', 'item_description_ar','vendor_id','vendor_cat_id', 'vendor_cat_id', 'item_name_ar','photo','price','time'];
    public function vender()
    {
        return  $this->belongsTo(Vendor_detail::class, 'vendor_id', 'id');
    }

    public function vendor_category()
    {
        return $this->belongsTo(Vendor_item_Category::class,'vendor_cat_id','id');
    }
    public function gallery()
    {
        return $this->hasMany(Item_gallery::class);
    }

    public function wishlist()
    {
        return $this->hasMany(Wishlist::class);
    }


}
