<?php

namespace App\Models\Project;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Project\Invoice_detail;
use App\Models\Project\Products;
use App\Models\Project\Vendor_detail;
use App\Models\Admin\User;

class Invoice_main extends Model
{
    use HasFactory;
    protected $table = 'invoice_main';
    protected $casts = [
        'payment_type' => 'integer',
        'is_approve' => 'integer'
    ];

    public function invoice_details()
    {
        return $this->hasMany(Invoice_detail::class);
    }

    public function products()
    {
        return $this->belongsTo(Products::class,'product_id','id');
    }

    public function attachments()
    {
        return $this->hasMany(Invoice_attachment::class,'invoice_main_id','id');
    }

    public function customer()
    {
        return $this->belongsTo(User::class,'user_id','id');
    }

    public function vendor()
    {
        return $this->belongsTo(User::class,'vendor_id','id');
    }
}
