<?php

namespace App\Models\Project;

use App\Models\Project\Item;
use App\Models\Project\Vendor_detail;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Cart extends Model
{
    use HasFactory;
    protected $fillable = ['user_id','item_id','vendor_id','qty'];
    protected $table = 'carts';

    public function item()
    {
        return $this->belongsTo(Item::class,'item_id','id');
    }

    public function vendor()
    {
        return $this->belongsTo(Vendor_detail::class,'vendor_id','id');
    }
}
