<?php

namespace App\Models\Admin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Support extends Model
{
    use HasFactory;
    protected $fillable = ['type','message', 'attachments','status','user_id'];

    protected $casts = [
        'attachments' => 'json',
    ];

    public function detail()
    {
        return $this->hasMany(SupportChat::class);
    }

    public function support_type()
    {
        return $this->belongsTo(SupportType::class,'type','id');
    }
}
