<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class SingleMail extends Mailable
{
    use Queueable, SerializesModels;
    public $subject;
    public $from_name;
    public $from_email;
    protected $content;
    protected $username;
    protected $files;

    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data=array(), $files=array())
    {
        $this->subject = $data['subject'];
        $this->username = $data['username'];
        $this->email = $data['email'];
        $this->content = $data['content'];
        $this->from_name = $data['from_name'];
        $this->from_email = $data['from_email'];
        $this->files = $files;
    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        $attach="";
        if ($this->files) {
            if(count($this->files) > 0) {
                foreach($this->files as $file) {
                    $attach .= "
                        ->attach($file, array(
                          'as' => $file,      
                          'mime' => $file)
                        )
                    ";
                }
            }
        }
        return $this->from($this->from_email, $this->from_name)
        ->subject($this->subject)
        ->view('admin/templates.email_template')->with([
            'subject' => $this->subject, 
            'content' => $this->content,
        ]);
    }
}
