<?php

namespace App\Imports;

use App\Models\Project\Products;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Illuminate\Support\Facades\Auth;

use Illuminate\Support\Collection;
use Maatwebsite\Excel\Concerns\ToCollection;

class ProductsImport implements ToModel, WithStartRow
{
    public function startRow(): int
    {
        return 2;
    }

    public function model(array $row)
    {
        //ddd($row);
        return new Products([
            'name'  => $row[0],
            'price' => (int) $row[1],
            'barcode' => $row[2],
            'category_id' => (int) $row[3],
            'vendor_id' => (int) Auth::id(),
        ]);
    }
}

// class ProductsImport implements ToCollection
// {
//     public function collection(Collection $rows)
//     {
//         foreach ($rows as $row) 
//         {
//             Products::create([
//                 'name'  => $row[0],
//                 'price' => $row[1],
//                 'barcode' => $row[2],
//                 'category_id' => $row[3],
//                 'vendor_id' => Auth::id(),
//             ]);
//         }
//     }
// }