<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class addPortFolioRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'type' => 'required|max:255',
            'title_en' => 'required',
            'title_ar' => 'required',
            'clientname' => 'required',
            'websiteurl' => 'required',
        ];
    }
    public function messages()
    {
        return [
            'type.required' => "Portfolio Type is required",
            'title_en.required' => "Title (en) is required",
            'title_ar.required' => "Title (ar) is required",
            'clientname.required' => "Client Name is required",
            'websiteurl.required' => "Website url is required",

        ];
    }
}
