<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\Project\Budget;
use App\Models\Admin\User;
use App\Models\Project\UserDetail;
use App\Models\Project\Vendor;
use App\Models\Project\Member;
use App\Models\Project\Expense_type;
use App\Models\Project\Expense_types_user;
use App\Traits\ApiLanguageTrait;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class UserProfileController extends Controller
{
	use ApiLanguageTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {   
    	if($request->apptype == "app"){ $id = $request->user_id; } else{ $id = Auth::id(); }
	    $data = array();

		$data['user_data'] = DB::select(DB::raw("SELECT a.id,a.uid,a.name,a.gender,a.age,b.country
        FROM user_detail a
		LEFT JOIN  users b ON a.uid = b.id			
        WHERE
        a.uid = '$id' ")); 
        return $data;   
    }

//view profile
  public function view(Request $request)
    {   
	 $data = array();
	$data['image_url'] = "https://sarfapp.com/project/user/";
    	if($request->apptype == "app"){ $id = $request->user_id; } else{ $id = Auth::id(); }
	   
		$data['user_data'] = DB::table('users')
			->join('user_detail', 'users.id', '=', 'user_detail.uid')
			->join('countries', 'users.country', '=', 'countries.id')
			->select(
				'user_detail.id','user_detail.uid','user_detail.name','user_detail.gender','user_detail.age',
				'users.image','users.country', 'users.username','users.mobile', 'countries.name_en', 'countries.name_ar'
			)
			->where('user_detail.uid', $id)
			->first();
			$data['user_data_status'] = 1;
		if(empty($data['user_data'])){	
			$data['user_data_status'] = 0;
		}		
        return $data;   
    }
	//rest pass
	public function change_pass(Request $request){
		$data = array();
		if($request->apptype == "app"){ $id = $request->user_id; } else{ $id = Auth::id(); }
		//$request->validate([
         //   'password' => ['required', 'min:5', 'confirmed']
       // ]);
	  	$post = User::find($id);
	  	$post->password = Hash::make($request->password);
	  	$msg = $post->save();
	  	if ($msg) {
			$data['msg_en'] = array('text' => $this->__transEn('password_changed_successfully'), 'cls' => 'success');
			$data['msg_ar'] = array('text' => $this->__transAr('password_changed_successfully'), 'cls' => 'success');
			$data['status'] = 1;
	  	}else{
	  		$data['msg_en'] = array('text' => $this->__transEn('not_change'), 'cls' => 'error');
	  		$data['msg_ar'] = array('text' => $this->__transEn('not_change'), 'cls' => 'error');
	  		$data['status'] = 0;
	  	}
	  	return $data;
	}


	//update profile info
	public function update(Request $request){
		$data = array();
		if($request->apptype == "app"){ $id = $request->user_id; } else{ $id = Auth::id(); }
		/*$request->validate([
            'name' => ['required'],
            'gender' => ['required'],
            'age' => ['required']
        ]);*/
        if (empty($request->name)) {
        	$data['msg_en'] = array('text' => $this->__transEn('name_is_required'), 'cls' => 'error');
		  	$data['msg_ar'] = array('text' => $this->__transAr('name_is_required'), 'cls' => 'error');
			$data['status'] = 0;
        }
        elseif (empty($request->gender)) {
        	$data['msg_en'] = array('text' => $this->__transEn('gender_is_required'), 'cls' => 'error');
		  	$data['msg_ar'] = array('text' => $this->__transAr('gender_is_required'), 'cls' => 'error');
			$data['status'] = 0;
        }
        elseif (empty($request->age)) {
        		$data['msg_en'] = array('text' => $this->__transEn('age_is_required'), 'cls' => 'error');
		  		$data['msg_ar'] = array('text' => $this->__transAr('age_is_required'), 'cls' => 'error');
				$data['status'] = 0;
        }
        else{
        	$msg = UserDetail::where('uid', $id)->update([
        		'name' => strip_tags($request->name),
        		'gender' => $request->gender,
        		'age' => intval($request->age),
        	]);
			  	if ($msg) {
						$post = User::find($id);
			  		$post->name = strip_tags($request->name);
			  		$post->country = $request->country;
			  		$msg = $post->save();
						$data['msg_en'] = array('text' => $this->__transEn('update_success'), 'cls' => 'success');
						$data['msg_ar'] = array('text' => $this->__transAr('update_success'), 'cls' => 'success');
						$data['status'] = 1;
			  	}else{
			  		$data['msg_en'] = array('text' => $this->__transEn('update_fail'), 'cls' => 'error');
			  		$data['msg_ar'] = array('text' => $this->__transAr('update_fail'), 'cls' => 'error');
			  		$data['status'] = 0;
			  	}
      }
	  	return $data;
	}
	
}
