<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\Project\Budget;
use App\Models\Admin\User;
use App\Models\Project\UserDetail;
use App\Models\Project\Vendor;
use App\Models\Project\Member;
use App\Models\Project\Invoice_main;
use App\Models\Project\Expense_type;
use App\Models\Project\Expense_types_user;
use App\Models\Project\Expenses;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Traits\ApiLanguageTrait;

class SalaryController extends Controller
{
	use ApiLanguageTrait;
    /**
     * Display a listing of the resource.
	 * 
     *
     * @return \Illuminate\Http\Response
     */


    public function manage_salary(Request $request)
	{
		$id = $request->user_id;	
		$data = array();
		if(isset( DB::table('budgets')->where('user_id', $id)->where('budget_type', '1')->first()->budget_amount)){
			$data['salary'] = DB::table('budgets')->where('user_id', $id)->where('budget_type', '1')->first()->budget_amount;
		}else{
			$data['salary'] = 0;
		}
		$data['salary_reset_date'] = DB::table('users')->where('id', $id)->first()->salary_reset_date;
		if(isset( DB::table('budgets')->where('user_id', $id)->where('budget_type', '1')->first()->id)){
			$salary_id = DB::table('budgets')->where('user_id', $id)->where('budget_type', '1')->first()->id;
			$data['salary_id'] = $salary_id ;
		}else{
			$salary_id = '0';
			$data['salary_id'] = '0' ;
		}
		
	$data['type_main'] =   DB::select(DB::raw("SELECT expense_types.id,expense_types.expense_name,expense_types.expense_name_ar,expense_types.color,(SELECT COALESCE(count(id),0) FROM expenses WHERE expense_type_id = expense_types.id AND user_id = '$id' AND budget_id = '$salary_id') AS exist,(SELECT COALESCE(count(id),0) FROM expenses WHERE expense_type_id = expense_types.id AND user_id = '$id' AND budget_id != '$salary_id') AS connect_other FROM `expense_types` WHERE type = 1 "));
$data['type_main_status'] = 1;
	if(empty($data['type_main'])){
		 $data['type_main_status'] = 0;
		$data['msg_en'] = $this->__transEn('main_type_not_found');
		$data['msg_ar'] = $this->__transAr('main_type_not_found');
	 }
      
	  $data['type_custom'] =   DB::select(DB::raw("SELECT expense_types.id,expense_types.expense_name,expense_types.color,(SELECT COALESCE(count(id),0) FROM expenses WHERE expense_type_id = expense_types.id AND user_id = '$id' AND budget_id = '$salary_id') AS exist,(SELECT COALESCE(count(id),0) FROM expenses WHERE expense_type_id = expense_types.id AND user_id = '$id' AND budget_id != '$salary_id') AS connect_other FROM `expense_types` WHERE type != 1 AND user_id = '$id'"));
$data['type_custom_status'] = 1;
	if(empty($data['type_custom'])){
		 $data['type_custom_status'] = 0;
		$data['msg_en'] = $this->__transEn('custom_type_not_found');
		$data['msg_ar'] = $this->__transAr('custom_type_not_found');
	 }
	
        return $data;  
	}
	
	public function salary_update(Request $request){
			$data = array();
		//	return $request->all;
			$salary_id = $request->salary_id;
			// DB::table('expense_types')->where('budget_id',$salary_id)->where('user_id', $request->user_id)->where('type', 2)->update(array('budget_id' => 0));

			// DB::table('expenses')->where('budget_id', $salary_id)->where('user_id', $request->user_id)->update(array('budget_id' => 0));
		//	return $request->expense_type_array;
			if (isset(Budget::where('user_id', $request->user_id)->where('budget_type', 1)->first()->id)) {
				$post = Budget::find($salary_id);
			  	$post->budget_amount = $request->salary_amount;
			  	$post->dated = Date('Y-m-d');
			  	$msg = $post->save();
			} else{
				$post = new Budget;
			  	$post->budget_name = 'Salary';
			  	$post->user_id = $request->user_id;
			  	$post->budget_amount = $request->salary_amount;
			  	$post->dated = Date('Y-m-d');
			  	$msg = $post->save();
			}
			if ($msg) {		
				// $ids = explode (",", $request->expense_type_array);
				// foreach ($ids as $val) {
				// 	DB::table('expense_types')
				// 		->where('id', intval($val))
				// 		->where('user_id', $request->user_id)
				// 		->update(array('budget_id' => $post->id));
				// 		DB::table('expenses')
				// 		->where('expense_type_id', intval($val))
				// 		->where('user_id', $request->user_id)
				// 		->update(array('budget_id' => $post->id));
				// }
				$data['msg_en'] = array('text' => $this->__transEn('saved_successfully'), 'cls' => 'success');
				$data['msg_ar'] = array('text' => $this->__transAr('saved_successfully'), 'cls' => 'success');
				$data['status'] = 1;
	        } else {
				$data['msg_en'] = array('text' => $this->__transEn('not_saved'), 'cls' => 'error');
				$data['msg_ar'] = array('text' => $this->__transAr('not_saved'), 'cls' => 'error');
				$data['status'] = 0;
	        }	 
		
	 	return $data; 
	}
	   
	   
	   	public function salary_reset(Request $request){
				$id = $request->salary_id;
				$data = array();
		
			// DB::table('budgets')->where('id', $id)->where('budget_type', 1)->update(array('budget_amount' => 0));
			$msg = DB::table('invoice_main')->where('budget_id', $id)->update(array('is_reset' => 1));
			if ($msg) {
				$data['msg_en'] = array('text' => $this->__transEn('reset_success'), 'cls' => 'success');
				$data['msg_ar'] = array('text' => $this->__transAr('reset_success'), 'cls' => 'success');
				$data['status'] = 1;
	        } else {
				$data['msg_en'] = array('text' => $this->__transEn('not_reset'), 'cls' => 'error');
				$data['msg_ar'] = array('text' => $this->__transAr('reset_success'), 'cls' => 'error');
				$data['status'] = 0;
	        }	 
		
	 	return $data; 
	}

	   
	public function salary_reset_monthly(Request $request){
		$id = $request->salary_id;
		$data = array();

	$msg = DB::table('users')->where('id', $id)->update(array('salary_reset_date' => $request->day_month));
	
	if ($msg) {
		$data['msg_en'] = array('text' => $this->__transEn('reset_success'), 'cls' => 'success');
		$data['msg_ar'] = array('text' => $this->__transAr('reset_success'), 'cls' => 'success');
		$data['status'] = 1;
	} else {
		$data['msg_en'] = array('text' => $this->__transEn('not_reset'), 'cls' => 'error');
		$data['msg_ar'] = array('text' => $this->__transAr('reset_success'), 'cls' => 'error');
		$data['status'] = 0;
	}	 

 return $data; 
}
	
}
