<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\Project\Pages;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Traits\ApiLanguageTrait;

class PagesController extends Controller
{
	use ApiLanguageTrait;
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {   
	    $data = array();
    	$action = strip_tags($request->action);
    	$lang = strip_tags($request->lang);
	    if ($action == 'term') {
	    	if ($lang == 'en') {
	    		$data['content'] = Pages::where('slug','terms')->first()->content_en;
	    	} else{
	    		$data['content'] = Pages::where('slug','terms')->first()->content_ar;
	    	}
	    	$data['content_status'] = 1;
			if(empty($data['content'])){
				$data['msg_en'] = $this->__transEn('page_content_not_found');
				$data['msg_ar'] = $this->__transAr('page_content_not_found');
				$data['content_status'] = 0;
			}
	    } 
		else if ($action == 'term_delete') {
	    	if ($lang == 'en') {
	    		$data['content'] = Pages::where('slug','terms')->first()->content_en;
	    	} else{
	    		$data['content'] = Pages::where('slug','terms')->first()->content_ar;
	    	}
	    	$data['content_status'] = 1;
			if(empty($data['content'])){
				$data['msg_en'] = $this->__transEn('page_content_not_found');
				$data['msg_ar'] = $this->__transAr('page_content_not_found');
				$data['content_status'] = 0;
			}
	    } 
		else if($action == 'privacy'){
	    	if ($lang == 'en') {
	    		$data['content'] = Pages::where('slug','privacy')->first()->content_en;
	    	} else{
	    		$data['content'] = Pages::where('slug','privacy')->first()->content_ar;
	    	}
	    	$data['content_status'] = 1;
			if(empty($data['content'])){
				$data['msg_en'] = $this->__transEn('page_content_not_found');
				$data['msg_ar'] = $this->__transAr('page_content_not_found');
				$data['content_status'] = 0;
			}
	    } else if($action == 'about'){
	    	if ($lang == 'en') {
	    		$data['content'] = Pages::where('slug','about')->first()->content_en;
	    	} else{
	    		$data['content'] = Pages::where('slug','about')->first()->content_ar;
	    	}
	    	$data['content_status'] = 1;
			if(empty($data['content'])){
				$data['msg_en'] = $this->__transEn('page_content_not_found');
				$data['msg_ar'] = $this->__transAr('page_content_not_found');
				$data['content_status'] = 0;
			}
	    }	
        return $data;   
    }	
}
