<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\Admin\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Validation\ValidationException;
use Illuminate\Support\Facades\DB;
use App\Traits\ApiLanguageTrait;

class LoginController extends Controller
{
    use ApiLanguageTrait;

    /*Login*/
    public function login(Request $request)
    {
        $data = array();
        /*$request->validate([
            'email' => ['required', 'email'],
            'password' => ['required']
        ]);*/
        $username = $request->username;
        $msgType = "username";
        $user = User::where(['username'=>$request->username, 'status'=>1])->first();
        if (is_numeric($username)) {
            $user = User::where(['mobile'=>$username, 'status'=>1])->first();
            $msgType = "mob";
        }

        if ($user != null) {
            if (Hash::check($request->password, $user->password)) {
                // if ($user->user_type != $request->type) {
                //     if ($request->type = 2 && $user->user_type = 1) {
                //         $data['status'] = 0;
                //         $data['msg_en'] = $this->__transEn('please_select_user_type_first');
                //         $data['msg_ar'] = $this->__transAr('please_select_user_type_first');
                //     } else {
                //         $data['status'] = 0;
                //         $data['msg_en'] = $this->__transEn('please_select_business_type_first');
                //         $data['msg_ar'] = $this->__transAr('please_select_business_type_first');
                //     }
                // } else {

                    if ($request->has('ios_device_id')) {
                        $data1 = [
                            'locale' => $request->language,
                            'ios_device_id' => $request->ios_device_id,
                        ];
                        User::where('id', $user->id)->update($data1);
                    }
                    if ($request->has('andriod_device_id')) {
                        $data2 = [
                            'locale' => $request->language,
                            'android_device_id' => $request->andriod_device_id,
                        ];
                        User::where('id', $user->id)->update($data2);
                    }

                    $data['status'] = 1;
                    $data['msg_en'] = $this->__transEn('login_success');
                    $data['msg_ar'] = $this->__transAr('login_success');
                    $data['data'] = $user;
                // }
            } else {
                $data['status'] = 0;
                $data['msg_en'] = $this->__transEn('password_incorrect');
                $data['msg_ar'] = $this->__transAr('password_incorrect');
            }
        } else {
            $data['status'] = 0;
            $data['msg_en'] = $this->__transEn($msgType.'_no_not_found');
            $data['msg_ar'] = $this->__transAr($msgType.'_no_not_found');
        }
        /* if (Auth::attempt($request->only('username', 'password'))){
            //return response()->json(Auth::user(), 200);
            $data['status'] = 1;
            $data['msg_en'] = "Login success";
            $data['msg_ar'] = "Login success";
            $data['data'] = Auth::user();
        }else{
            $data['status'] = 0;
            $data['msg_en'] = "The provided credentials are incorect.";
            $data['msg_ar'] = "The provided credentials are incorect.";
        }*/
        return response()->json($data);
        /*throw ValidationException::withMessages([
            'email' =>['The provided credentials are incorect.']
        ]);*/
    }

    /*Logout*/
    public function logout()
    {
        Auth::logout();
    }

    /*otp checking*/
    public function otp(Request $request)
    {
        $request->validate([
            'otp' => ['required'],
        ]);

        $otp = strip_tags($request->otp);
        if ($otp == Auth::user()->otp) {
            //return response()->json(200);
            $data['status'] = 1;
            $data['msg_en'] = "Success";
            $data['msg_ar'] = "Success";
        } else {
            $data['status'] = 0;
            $data['msg_en'] = "Incorect OTP.";
            $data['msg_ar'] = "Incorect OTP.";
        }
        return $data;
        /*throw ValidationException::withMessages([
            'otp' =>['Incorect OTP.']
        ]);*/
    }
}
