<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\Project\Budget;
use App\Models\Project\Colors;
use App\Models\Admin\User;
use App\Models\Project\Vendor;
use App\Models\Project\Member;
use App\Models\Project\Invoice_main;
use App\Models\Project\Invoice_detail;
use App\Models\Project\Expense_type;
use App\Models\Project\Expense_types_user;
use App\Models\Project\Products;
use App\Models\Project\Categories;
use App\Models\Project\BusinessDetail;
use App\Models\Project\Offers;
use App\Models\Project\Offer_users;
use App\Models\Project\Subscription;
use App\Models\Project\Alerts;
use App\Models\Project\Invoice_attachment;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use App\Traits\ApiLanguageTrait;
use Illuminate\Support\Facades\Validator;
use App\Traits\CommunicationTrait;
use App\Models\Admin\NotificationTemplate;
use Illuminate\Support\Str;


use Session;

class HomeVendorController extends Controller
{
	use CommunicationTrait, ApiLanguageTrait;
	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index(Request $request)
	{
	}

	public function budget_and_expances(Request $request)
	{
		$data = array();
		$data['expense_chart']['budget_amount'] = Budget::where(['user_id' => $request->user_id, 'budget_type' => 1, 'budget_status' => 1])->sum('budget_amount');
		$data['expense_chart']['total_expenses'] = Invoice_main::where(['user_id' => $request->user_id, 'is_reset' => 0])->sum('net_total');

		// budget data.
		$data['budget_id'] = (string) Budget::where(['user_id' => $request->user_id, 'budget_type' => 1, 'budget_status' => 1])->first()->id;
		$budget_list = Budget::query()->select('id', 'project_number', 'budget_name', 'budget_amount')->where(['user_id' => $request->user_id, 'budget_type' => 2, 'budget_status' => 1])->get();
		$data['budget_list'] = [];
		foreach ($budget_list as $key => $bud) {
			$data['budget_list'][] = $bud;
			$data['budget_list'][$key]['total_expenses'] = DB::table('invoice_main')->where('user_id', $request->user_id)->where('is_reset', 0)->where('budget_id', $bud->id)->sum('net_total');
		}
		$data['status'] = 1;
		// if (empty($data['budget_list']) && $data['expense_chart']['budget_amount'] == 0 && $data['expense_chart']['total_expenses'] == 0) {
		// 	$data['status'] = 0;
		// 	$data['msg_en'] = array('text' => 'Sorry data not found', 'cls' => 'text-danger');
		// 	$data['msg_ar'] = array('text' => 'Sorry data not found ar', 'cls' => 'text-danger');
		// 	return $data;
		// }
		return $data;
	}

	//
	public function generate_invoice(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$user_id = getAny('user_id', 'invoice_main', 'id', $request->invoice_id);

		if (isset(DB::table('members')->where('vendor_id', $id)->where('user_id', $user_id)->first()->expense_type)) {
			$vendor_type = DB::table('members')->where('vendor_id', $id)->where('user_id', $user_id)->first()->expense_type;
			$budget_id = DB::table('expenses')->where('user_id', $user_id)->where('expense_type_id', $vendor_type)->first()->budget_id;
		} else {
			$vendor_type = 0;
		}
		$data = array();
		$post =  Invoice_main::find($request->invoice_id);
		$post->created_at = Date('Y-m-d H:i:s');
		$post->date = Date('Y-m-d');
		$post->invoice_note = $request->note;
		$post->total_amount = $request->total_amount;
		$post->discount_invoice = $request->discount;
		$post->extra_discount = $request->extra_discount;
		$post->tax = $request->tax_total;
		$post->net_total = $request->net_amount;
		$post->expense_type = $vendor_type;
		$post->budget_id = $budget_id;
		$post->status = 1;
		$msg = $post->save();
		if ($msg) {
			$post2 = new Alerts;
			$post2->user_id = getAny('user_id', 'invoice_main', 'id', $request->invoice_id);
			$post2->vendor_id = 0;
			$post2->inv_offer_id = $request->invoice_id;
			$post2->title = "Invoice generated";
			$post2->discription = $request->note;
			$post2->alert_type = 1;
			$msg2 = $post2->save();

			$data['msg_en'] = array('text' => $this->__transEn('generated_successfully'), 'cls' => 'success');
			$data['msg_ar'] = array('text' => $this->__transAr('generated_successfully'), 'cls' => 'success');
			$data['status'] = 1;
		} else {
			$data['msg_en'] = array('text' => $this->__transEn('fail'), 'cls' => 'error');
			$data['msg_ar'] = array('text' => $this->__transAr('fail'), 'cls' => 'error');
			$data['status'] = 0;
		}
		return $data;
	}

	// simple invoice members barcode
	public function simple_invoice_member_qrcode(Request $request)
	{
		$data = array();
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		// checking qrcode
		$mobile = $request->qrcode;
		$project_number = 0;
		if (str_contains($request->qrcode, '#')) {
			$mob_ary = explode('#', $request->qrcode);
			$mobile = $mob_ary[0];
			$project_number = $mob_ary[1];
			$user_id = DB::table('users')->where('mobile', $mobile)->where('status', 1)->first()->id;

		}else{
			// get last character of QrCode
			$lastChar = substr($request->qrcode, -1);

			if ($lastChar == 1) {
				$user_id = DB::table('user_detail')->where('qrcode', $request->qrcode)->where('status', 1)->first()->uid ?? 0;
			}else {
				$user_id = DB::table('vendor_detail')->where('qrcode', $request->qrcode)->where('vendor_status', 1)->first()->uid ?? 0;
			}
			
		}
		
		if ($user_id > 0 ) {
			// $user_id = DB::table('user_detail')->where('qrcode', $qrcode)->where('status', 1)->first()->uid;
			$vendor_type = DB::table('vendor_detail')->where('uid', $id)->first()->type;
			if (!isset(DB::table('members')->where('vendor_id', $id)->where('user_id', $user_id)->first()->id)) {
				$post1 = new Member;
				$post1->user_id = $user_id;
				$post1->vendor_id = $id;
				$post1->expense_type = $vendor_type;
				$msg1 = $post1->save();
			}
			$data['username'] = DB::table('users')->where('id', $user_id)->first()->username.( $project_number > 0 ? "#".$project_number : "" );
			$data['barcode_status'] = 1;

		} else {
			$data['msg_en'] = array('text' => $this->__transEn('Qr code not match'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('Qr code not match'), 'cls' => 'text-danger');
			$data['barcode_status'] = 0;

		}
	
		return $data;
	}

	// simple invoice members barcode
	public function checking_member_qrcode(Request $request)
	{
		$data = array();
		// checking qrcode
		$qrcode = $request->qrcode;
		$project_number = 0;
		if (str_contains($request->qrcode, '#')) {
			$mob_ary = explode('#', $request->qrcode);
			$qrcode = $mob_ary[0];
			$project_number = $mob_ary[1];
		}
		if (isset($qrcode) && !empty($qrcode)) {
			if (isset(DB::table('user_detail')->where('qrcode', $qrcode)->where('status', 1)->first()->id)) {

				$vendor_type = DB::table('vendor_detail')->where('uid', $request->user_id)->first()->type;
				$user_id = DB::table('user_detail')->where('qrcode', $qrcode)->where('status', 1)->first()->uid;
				if (!isset(DB::table('members')->where('vendor_id', $request->user_id)->where('user_id', $user_id)->first()->id)) {
					$post1 = new Member;
					$post1->user_id = $user_id;
					$post1->vendor_id = $request->user_id;
					$post1->expense_type = $vendor_type;
					$msg1 = $post1->save();
				}
				$data['username'] = DB::table('users')->where('id', $user_id)->first()->username;
				$data['user_id'] = $user_id;
				$data['barcode_status'] = 1;
			} else {
				$data['msg_en'] = $this->__transEn('Qr code not match');
				$data['msg_ar'] = $this->__transAr('Qr code not match');
				$data['barcode_status'] = 0;
			}
		}
		return $data;
	}

	// simple invoice
	public function checking_user_by_username(Request $request)
	{
		$data = array();
		// generate simple invoice
		$username = $request->username;
		$project_number = 0;
		$project_name = "";
		if (str_contains($request->username, '#')) {
			$mob_ary = explode('#', $request->username);
			$username = $mob_ary[0];
			$project_number = $mob_ary[1];
			
		}
		
		if (User::where('username', $username)->orwhere('mobile', $username)->exists()) {
			// 
			if (!empty(User::where('username', $username)->first()->id)) {
				$user_id = User::where('username', $username)->first()->id;
				
				if (str_contains($request->username, '#')) {
					$project_name = "# Not Found";
					if (!empty(Budget::where(['user_id'=> $user_id, 'project_number'=>'#'.$project_number])->first()->id)) {
						$project = Budget::where(['user_id'=> $user_id, 'project_number'=>'#'.$project_number])->first();
						// if (str_contains($request->username, '#')) {
							$project_name = ($project != null) ? "# ".$project->budget_name : " Not found";
						// }
					}
				}

				if ( User::where('id', $user_id)->first()->type == 1 ) {
					$data['username'] = DB::table('user_detail')->where('uid', $user_id)->first()->name." ".$project_name;
				}else{
					$data['username'] = DB::table('vendor_detail')->where('uid', $user_id)->first()->name." ".$project_name;
				}
				
				$data['user_id'] = $user_id;
				$data['status'] = 1;

			} elseif (!empty(User::where('mobile', $username)->first()->id)) {
				$user_id = User::where('mobile', $username)->first()->id;

				if (str_contains($request->username, '#')) {
					$project_name = "# Not Found";
					if (!empty(Budget::where(['user_id'=> $user_id, 'project_number'=>'#'.$project_number])->first()->id)) {
						$project = Budget::where(['user_id'=> $user_id, 'project_number'=>'#'.$project_number])->first();
						// if (str_contains($request->username, '#')) {
							$project_name = ($project != null) ? "# ".$project->budget_name : " Not found";
						// }
					}
				}
				if ( User::where('id', $user_id)->first()->type == 1 ) {
					$data['username'] = DB::table('user_detail')->where('uid', $user_id)->first()->name." ".$project_name;
				}else{
					$data['username'] = DB::table('vendor_detail')->where('uid', $user_id)->first()->name." ".$project_name;
				}
				$data['user_id'] = $user_id;
				$data['status'] = 1;
			}
			if (!isset(DB::table('members')->where('vendor_id', $request->user_id)->where('user_id', $user_id)->first()->id)) {
				$vendor_type = DB::table('vendor_detail')->where('uid', $request->user_id)->first()->type;
				$post1 = new Member;
				$post1->user_id = $user_id;
				$post1->vendor_id = $request->user_id;
				$post1->expense_type = $vendor_type;
				$msg1 = $post1->save();
			}
			return $data;
		} else {
			$data['msg_en'] = $this->__transEn('user_not_found');
			$data['msg_ar'] = $this->__transAr('user_not_found');
			$data['status'] = 0;
		}
		return $data;
	}

	// simple invoice
	public function generate_simple_invoice(Request $request)
	{
		$data = array();
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}

		$mobile = $request->mobile;
		$project_number = 0;
		if (str_contains($request->mobile, '#')) {
			$mob_ary = explode('#', $request->mobile);
			$mobile = $mob_ary[0];
			$project_number = $mob_ary[1];
			if (Budget::where(['user_id'=> $id, 'project_number'=>'#'.$project_number])->doesntExist()) {
				$data['simple_inv_status'] = 0;
				$data['msg_en'] = array('text' => '#'.$project_number.$this->__transEn('Project not found'), 'cls' => 'text-danger');
				$data['msg_ar'] = array('text' => '#'.$project_number.$this->__transAr('Project not found'), 'cls' => 'text-danger');
				return $data; 
				exit();
			}
		}
		
		// generate simple invoice
		if (User::where('username', $mobile)->orwhere('mobile', $mobile)->exists()) {
			$user_id = 0;
			if (!empty(User::where('username', $mobile)->first()->id)) {
				$user_id = User::where('username', $mobile)->first()->id;

			} elseif (!empty(User::where('mobile', $mobile)->first()->id)) {
				$user_id = User::where('mobile', $mobile)->first()->id;
			}

			

			$member_id =  DB::table('members')->where('vendor_id', $id)->where('user_id', $user_id)->first()->expense_type;
			$vendor_type = DB::table('members')->where('vendor_id', $id)->where('user_id', $user_id)->first()->expense_type;
			$budget_id = Budget::where(['user_id' => $user_id, 'budget_type' => 1, 'budget_status' => 1])->first()->id;

			//return $request->username." ".$user_id; 
			$post = new Invoice_main;
			$post->vendor_id = ($id) ? $id : 0;
			$post->user_id = ($user_id) ? $user_id : 0;
			$post->invoice_note = $request->invoice_note;
			$post->net_total = $request->net_total;
			$post->date = Date('Y-m-d');
			$post->created_at = Date('Y-m-d H:i:s');
			$post->status = 1;
			$post->invoice_type = 2;
			$post->expense_type = $vendor_type;
			$post->paid_status = $request->paid_status;
			if ($request->paid_status == 1) {
				$post->is_approve = 1;
			}
			$post->budget_id = (str_contains($request->mobile, '#')) ? Budget::where(['user_id'=> $user_id, 'project_number' => '#'.$project_number])->first()->id : $budget_id;
			$msg = $post->save();

			$inv_id = $post->id;
			// file att
			//$allowedfileExtension=['pdf','docx','jpg','png'];
			$files = $request->file('file_attach');
			if ($files) {
				/*foreach ($files as $file) {   
					$extension = $file->getClientOriginalExtension();
					$check = in_array($extension,$allowedfileExtension);*/
				//if($check) {
				foreach ($request->file_attach as $mediaFiles) {
					$name = 'project/invoice_attachments/' . Str::random(30) . ".png";
					$mediaFiles->move(public_path('project/invoice_attachments/'), $name);
					//$path = $mediaFiles->store('images/invoice_attachments/');
					//	$file->move(public_path('project/support/');
					//store image file into directory and 
					$attachData = [
						'invoice_main_id' => $inv_id,
						'file_attach' => $name,
					];
					Invoice_attachment::insert($attachData);
				}
				/*} else {
						$data['msg_en'] = $this->__transEn('invalid_file_format');
						$data['msg_ar'] = $this->__transAr('invalid_file_format');
						$data['simple_inv_status'] = 0;
					}*/
				//}
			}
			// file upload ends here
			if ($msg) {
				$template_inv_en = NotificationTemplate::where('slug', 'make_invoice_from_vendor_en')->first();
				$template_inv_ar = NotificationTemplate::where('slug', 'make_invoice_from_vendor_ar')->first();

				$title = $template_inv_en->title;
				$title = str_replace('{{provider}}', vendorInfo($id, 'name'), $title);
				$title = str_replace('{{order_id}}', $inv_id, $title);
				$title = str_replace('{{customer_name}}', customerInfo($id, 'name'), $title);
				$msg = $template_inv_en->text;
				$msg = str_replace('{{provider}}', vendorInfo($id, 'name'), $msg);
				$msg = str_replace('{{order_id}}', $inv_id, $msg);
				$msg = str_replace('{{customer_name}}', customerInfo($id, 'name'), $msg);

				$title_ar = $template_inv_ar->title;
				$title_ar = str_replace('{{provider}}', vendorInfo($request->vendor_id, 'name'), $title_ar);
				$title_ar = str_replace('{{order_id}}', $inv_id, $title_ar);
				$title_ar = str_replace('{{customer_name}}', customerInfo($id, 'name'), $title_ar);
				$msg_ar = $template_inv_ar->text;
				$msg_ar = str_replace('{{provider}}', vendorInfo($id, 'name'), $msg_ar);
				$msg_ar = str_replace('{{order_id}}', $inv_id, $msg_ar);
				$msg_ar = str_replace('{{customer_name}}', customerInfo($id, 'name'), $msg_ar);

				$post2 = new Alerts;
				$post2->user_id = $user_id;
				$post2->vendor_id = 0;
				$post2->ref_id = $inv_id;
				$post2->title = $title;
				$post2->title_ar = $title_ar;
				$post2->discription = $msg;
				$post2->discription_ar = $msg_ar;
				$post2->alert_type = 1;
				$msg2 = $post2->save();

				$lang = userInfo($user_id, 'locale');
				if ($lang == 'en') {
					$notify = [
						'uid' => $user_id,
						'type' => 1,
						'apptype' => 'user',
						'ref_id' => $inv_id,
						'title' => $title,
						'message' => $msg,
					];
				} else {
					$notify = [
						'uid' => $user_id,
						'type' => 1,
						'apptype' => 'user',
						'ref_id' => $inv_id,
						'title' => $title_ar,
						'message' => $msg_ar,
					];
				}
				//$this->SendAlertNotification($notify);



				$data['msg_en'] = array('text' => $this->__transEn('generated_successfully'), 'cls' => 'success');
				$data['msg_ar'] = array('text' => $this->__transAr('generated_successfully'), 'cls' => 'success');
				$data['simple_inv_status'] = 1;
			} else {
				$data['simple_inv_status'] = 0;
				$data['msg_en'] = array('text' => $this->__transEn('not_found'), 'cls' => 'text-danger');
				$data['msg_ar'] = array('text' => $this->__transAr('not_found'), 'cls' => 'text-danger');
			}
		} else {
			$data['simple_inv_status'] = 0;
			$data['msg_en'] = array('text' => $this->__transEn('member_not_found'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('member_not_found'), 'cls' => 'text-danger');
		}
		return $data;
	}

	//
	public function members(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$data['members'] = Member::all()->where('user_id', $id);
		$data['members_status'] = 1;
		if (empty($data['members'])) {
			$data['members_status'] = 0;
			$data['msg_en'] = array('text' => $this->__transEn('not_found'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('not_found'), 'cls' => 'text-danger');
		}
		return $data;
	}
	//
	public function member_search(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$data['member_search'] = DB::table('members')
			->join('vendor_detail', 'members.user_id', '=', 'vendor_detail.uid')
			->select('members.*', 'vendor_detail.*')
			->where('vendor_detail.name', $request->name)
			->get();
		$data['member_search_status'] = 1;
		if (empty($data['member_search'])) {
			$data['member_search_status'] = 0;
			$data['msg_en'] = array('text' => $this->__transEn('not_found'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('not_found'), 'cls' => 'text-danger');
		}
		return $data;
	}

	//
	public function products(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$data['products'] = Products::where('vendor_id', $id)->get();
		$data['products_status'] = 1;
		if (empty($data['products'])) {
			$data['products_status'] = 0;
			$data['msg_en'] = array('text' => $this->__transEn('not_found'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('not_found'), 'cls' => 'text-danger');
		}
		return $data;
	}
	//
	public function product_search(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$data['product_search'] = Products::where('name', $request->name)->get();
		$data['product_search_status'] = 1;
		if (empty($data['product_search'])) {
			$data['product_search_status'] = 0;
			$data['msg_en'] = array('text' => $this->__transEn('not_found'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('not_found'), 'cls' => 'text-danger');
		}
		return $data;
	}

	//
	public function member_offer(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$data['member_offer'] = Budget::where('product_id', $request->product_id)->get();
		$data['member_offer_status'] = 1;
		if (empty($data['member_offer'])) {
			$data['member_offer_status'] = 0;
			$data['msg_en'] = array('text' => $this->__transEn('not_found'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('not_found'), 'cls' => 'text-danger');
		}
		return $data;
	}

	//shan
	public function offer_add(Request $request)
	{
		$data = array();
		$post = new Budget;
		$post->member_id = intval($request->member_id);
		$post->product_id = intval($request->product_id);
		$post->quantity = intval($request->quantity);
		$post->unit = strip_tags($request->unit);
		$post->price = intval($request->price);
		$msg = $post->save();
		if ($msg) {
			$data['msg_en'] = array('text' => $this->__transEn('generated_successfully'), 'cls' => 'success');
			$data['msg_ar'] = array('text' => $this->__transAr('generated_successfully'), 'cls' => 'success');
			$data['status'] = 1;
		} else {
			$data['msg_en'] = array('text' => $this->__transEn('fail'), 'cls' => 'error');
			$data['msg_ar'] = array('text' => $this->__transAr('fail'), 'cls' => 'error');
			$data['status'] = 0;
		}
		return $data;
	}

	/*veiw profile*/
	public function business_profile(Request $request)
	{
		$data = array();
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::id();
		}
		$data['img_path'] = "https://sarfapp.com/project/vendors/";
		$data['profile'] = DB::table('vendor_detail')
			->select(
				'vendor_detail.*',
				DB::raw(
					"(SELECT expense_name FROM expense_types WHERE expense_types.id = vendor_detail.type) as type_name"
				),
				DB::raw(
					"(SELECT expense_name_ar FROM expense_types WHERE expense_types.id = vendor_detail.type) as type_name_ar"
				)
			)
			->where('uid', $id)
			->first();
		$data['profile_status'] = 1;
		if (empty($data['profile'])) {
			$data['profile'] = "";
			$data['msg_en'] = $this->__transEn('record_not_found');
			$data['msg_ar'] = $this->__transAr('record_not_found');
			$data['profile_status'] = 0;
		}
		return $data;
	}

	//update profile info
	public function update_business_profile(Request $request)
	{
		$data = array();
		if (empty($request->name)) {
			$data['msg_en'] = $this->__transEn('name_is_required');
			$data['msg_ar'] = $this->__transAr('name_is_required');
			$data['status'] = 0;
		} else {
			if ($request->image_change == 1) {
				$folderPath = "project/vendors/";
				$image_name = $request->id . '_' . $request->name . '_' . date('Y-m-d_H_i_s') . '.png';
				$file = $folderPath . $image_name;
				$image = base64_decode($request->logo);
			}
			$post = BusinessDetail::find($request->id);
			$post->name = strip_tags($request->name);
			$post->type = $request->type;
			$post->lisence_no = $request->lisence_no;
			$post->ref_no = $request->ref_no;
			$post->insta_link = $request->insta_link;
			$post->twitter_link = $request->twitter_link;
			$post->website = $request->website;
			$post->whatsapp = $request->whatsapp;
			$post->mobile = $request->mobile;
			$post->location_lat = $request->location_lat;
			$post->location_lng = $request->location_lng;
			$post->location = $request->location;
			if ($request->image_change == 1) {
				$post->logo = $image_name;
			}
			$msg = $post->save();
			if ($msg) {
				if ($request->image_change == 1) {
					file_put_contents($file, $image);
				}
				$post = User::find($request->uid);
				$post->name = $request->name;
				$post->mobile = $request->mobile;
				$msg = $post->save();
				$data['msg_en'] = $this->__transEn('update_success');
				$data['msg_ar'] = $this->__transAr('update_success');
				$data['status'] = 1;
			} else {
				$data['msg_en'] = $this->__transEn('update_fail');
				$data['msg_ar'] = $this->__transAr('update_fail');
				$data['status'] = 0;
			}
		}
		return $data;
	}
	//manage categories
	public function manage_categories(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$data['categories'] = Categories::where('vendor_id', $id)->get();
		$data['categories_status'] = 1;
		if (empty($data['categories'])) {
			$data['categories_status'] = 0;
			$data['msg_en'] = array('text' => $this->__transEn('not_found'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('not_found'), 'cls' => 'text-danger');
		}
		return $data;
	}
	//add category
	public function category_add(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$new_name = "no.png";
		if (Categories::where('name_en', $request->name_en)->where('vendor_id', $id)->exists()) {
			$data['msg_en'] = array('text' => $this->__transEn('name_already_exist'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('name_already_exist'), 'cls' => 'text-danger');
			$data['status'] = 0;
		} else if (Categories::where('name_ar', $request->name_ar)->where('vendor_id', $id)->exists()) {
			$data['msg_en'] = array('text' => $this->__transEn('name_ar_already_exist'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('name_ar_already_exist'), 'cls' => 'text-danger');
			$data['status'] = 0;
		} else {
			$photo = $request->file('cat_iamge');
			if ($photo) {
				$new_name = rand() . '.' . $photo->getClientOriginalExtension();
				$photo->move(base_path('public/images/vendors/category'), $new_name);
			}
			$post = new Categories;
			$post->name_en = $request->name_en;
			$post->name_ar = $request->name_ar;
			$post->cat_image = $new_name;
			$post->vendor_id = $id;
			$msg = $post->save();
			if ($msg) {
				$data['msg_en'] = array('text' => $this->__transEn('added_success'), 'cls' => 'text-success');
				$data['msg_ar'] = array('text' => $this->__transAr('added_success'), 'cls' => 'text-success');
				$data['status'] = 1;
			} else {

				$data['msg_en'] = array('text' => $this->__transEn('added_fail'), 'cls' => 'text-danger');
				$data['msg_ar'] = array('text' => $this->__transAr('added_fail'), 'cls' => 'text-danger');
				$data['status'] = 0;
			}
		}
		return $data;
	}

	//update categories
	public function category_update(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$new_name = "no.png";
		if (Categories::where('name_en', $request->name_en)->where('vendor_id', $id)->where('id', '!=', $request->cat_id)->exists()) {
			$data['msg_en'] = array('text' => $this->__transEn('name_already_exist'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('name_already_exist'), 'cls' => 'text-danger');
			$data['status'] = 0;
		} else if (Categories::where('name_ar', $request->name_ar)->where('vendor_id', $id)->where('id', '!=', $request->cat_id)->exists()) {
			$data['msg_en'] = array('text' => $this->__transEn('name_ar_already_exist'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('name_ar_already_exist'), 'cls' => 'text-danger');
			$data['status'] = 0;
		} else {
			if ($request->cat_image_update == '1') {
				$photo = $request->file('cat_iamge');
				if ($photo) {
					$new_name = rand() . '.' . $photo->getClientOriginalExtension();
					$photo->move(public_path('project/vendors/category'), $new_name);
				}
			}

			$post = Categories::find($request->cat_id);
			$post->name_en = $request->name_en;
			$post->name_ar = $request->name_ar;
			if ($request->cat_image_update == '1') {
				$post->cat_image = $new_name;
			}
			//$post->vendor_id = $id;
			$msg = $post->save();
			if ($msg) {
				$data['msg_en'] = array('text' => $this->__transEn('update_success'), 'cls' => 'text-success');
				$data['msg_ar'] = array('text' => $this->__transAr('update_success'), 'cls' => 'text-success');
				$data['status'] = 1;
			} else {

				$data['msg_en'] = array('text' => $this->__transEn('update_fail'), 'cls' => 'text-danger');
				$data['msg_ar'] = array('text' => $this->__transAr('update_fail'), 'cls' => 'text-danger');
				$data['status'] = 0;
			}
		}
		return $data;
	}
	//manage products
	public function manage_products(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$data['products'] = Products::where('vendor_id', $id)->get();
		$data['products_status'] = 1;
		if (empty($data['products'])) {
			$data['products_status'] = 0;
			$data['msg_en'] = array('text' => $this->__transEn('not_found'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('not_found'), 'cls' => 'text-danger');
		}
		return $data;
	}
	//add product
	public function product_add(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$new_name = "";
		if (Products::where('name', $request->name)->where('vendor_id', $id)->exists()) {
			$data['msg_en'] = array('text' => $this->__transEn('name_already_exist'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('name_already_exist'), 'cls' => 'text-danger');
			$data['status'] = 0;
		} else {
			$photo = $request->file('cat_iamge');
			if ($photo) {
				$new_name = rand() . '.' . $photo->getClientOriginalExtension();
				$photo->move(public_path('project/vendors/product'), $new_name);
			}
			$post = new Products;
			$post->name = $request->name;
			$post->price = $request->price;
			$post->barcode = $request->barcode;
			$post->category_id = $request->category_id;
			$post->vendor_id = $id;
			$msg = $post->save();
			if ($msg) {
				$data['msg_en'] = array('text' => $this->__transEn('added_success'), 'cls' => 'text-success');
				$data['msg_ar'] = array('text' => $this->__transAr('added_success'), 'cls' => 'text-success');
				$data['status'] = 1;
			} else {

				$data['msg_en'] = array('text' => $this->__transEn('added_fail'), 'cls' => 'text-danger');
				$data['msg_ar'] = array('text' => $this->__transAr('added_fail'), 'cls' => 'text-danger');
				$data['status'] = 0;
			}
		}
		return $data;
	}

	//update Product
	public function product_update(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$new_name = "";
		if (Products::where('name', $request->name)->where('vendor_id', $id)->where('id', '!=', $request->product_id)->exists()) {
			$data['msg_en'] = array('text' => $this->__transEn('name_already_exist'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('name_already_exist'), 'cls' => 'text-danger');
			$data['status'] = 0;
		} else {
			$post = Products::find($request->product_id);
			$post->name = $request->name;
			$post->price = $request->price;
			$post->barcode = $request->barcode;
			$post->category_id = $request->category_id;
			//$post->vendor_id = $id;
			$msg = $post->save();
			if ($msg) {
				$data['msg_en'] = array('text' => $this->__transEn('update_success'), 'cls' => 'text-success');
				$data['msg_ar'] = array('text' => $this->__transAr('update_success'), 'cls' => 'text-success');
				$data['status'] = 1;
			} else {

				$data['msg_en'] = array('text' => $this->__transEn('update_fail'), 'cls' => 'text-danger');
				$data['msg_ar'] = array('text' => $this->__transAr('update_fail'), 'cls' => 'text-danger');
				$data['status'] = 0;
			}
		}
		return $data;
	}


	//manage invoices
	public function manage_invoices(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$data['vendor_invoices'] =   DB::select(DB::raw("select a.id,a.net_total,a.date,a.paid_status  FROM invoice_main a
        WHERE
        a.vendor_id = '$id' AND a.status = 1 "));
		$data['vendor_invoices_status'] = 1;
		if (empty($data['vendor_invoices'])) {
			$data['vendor_invoices_status'] = 0;
			$data['msg_en'] = $this->__transEn('vendor_invoices_data_not_found');
			$data['msg_ar'] = $this->__transAr('vendor_invoices_data_not_found');
		}
		return $data;
	}

	//member invoices
	public function member_invoices(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$data['total_invoices'] = DB::table('invoice_main')->where('user_id', $request->member_id)->where('vendor_id', $request->user_id)->count();
		$data['total_amount']  = DB::table('invoice_main')->where('user_id', $request->member_id)->where('vendor_id', $request->user_id)->sum('net_total');
		$data['member_invoices'] =   DB::select(DB::raw("select a.id,a.net_total,a.date, a.invoice_type,a.paid_status FROM invoice_main a
        WHERE
        a.vendor_id = '$id' AND a.user_id = '$request->member_id' "));

		$data['member_invoices_status'] = 1;
		if (empty($data['member_invoices'])) {
			$data['member_invoices_status'] = 0;
			$data['msg_en'] = $this->__transEn('member_invoices_data_not_found');
			$data['msg_ar'] = $this->__transAr('member_invoices_data_not_found');
		}
		return $data;
	}

	//get invoice members
	public function invoice_members(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::id();
		}
		$data = array();
		$data['members_list'] =  DB::table('members')
			->join('user_detail', 'members.user_id', '=', 'user_detail.uid')
			->join('users', 'members.user_id', '=', 'users.id')
			->select('members.user_id', 'user_detail.name', 'users.mobile')
			->where('members.vendor_id', $id)
			->get();
		$data['members_status'] = 1;
		if (empty($data['members_list'])) {
			$data['members_status'] = 0;
			$data['msg_en'] = $this->__transEn('member_not_found');
			$data['msg_ar'] = $this->__transAr('member_not_found');
		}
		return $data;
	}

	//add member to invoice
	public function invoice_member_add(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();

		$ar['pending'] = DB::select(DB::raw("SELECT a.id,a.status from invoice_main a WHERE a.vendor_id = '$id' AND a.user_id = '$request->member_id' AND a.status = 3"));
		if (empty($ar['pending'])) {
			$post = new Invoice_main;
			$post->vendor_id = $id;
			$post->user_id = $request->member_id;
			$post->member_selected = 1;
			$post->status = 3;
			$msg = $post->save();
			if ($msg) {
				$invoice_main_id = $post->id;
				DB::table('invoice_main')->where('vendor_id', $id)->where('id',  '!=', $invoice_main_id)->where('status', 3)->update(array('member_selected' => 0));
				$data['msg_en'] = array('text' => $this->__transEn('added_success'), 'cls' => 'text-success');
				$data['msg_ar'] = array('text' => $this->__transAr('added_success'), 'cls' => 'text-success');
				$data['status'] = 1;
				$data['invoice_id'] = $invoice_main_id;
			} else {

				$data['msg_en'] = array('text' => $this->__transEn('added_fail'), 'cls' => 'text-danger');
				$data['msg_ar'] = array('text' => $this->__transAr('added_fail'), 'cls' => 'text-danger');
				$data['status'] = 0;
			}
		} else {
			DB::table('invoice_main')->where('vendor_id', $id)->where('user_id', $request->member_id)->where('status', 3)->update(array('member_selected' => 1));
			DB::table('invoice_main')->where('vendor_id', $id)->where('user_id',  '!=', $request->member_id)->where('status', 3)->update(array('member_selected' => 0));
			$data['msg_en'] = array('text' => $this->__transEn('member_invoice_already_pending'), 'cls' => 'text-success');
			$data['msg_ar'] = array('text' => $this->__transAr('member_invoice_already_pending'), 'cls' => 'text-success');
			$data['status'] = 1;
		}
		return $data;
	}



	public function invoice_member_barcode(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();


		if (isset(DB::table('user_detail')->where('qrcode', $request->qrcode)->where('status', 1)->first()->id)) {
			$user_id = DB::table('user_detail')->where('qrcode', $request->qrcode)->where('status', 1)->first()->uid;
			if (isset(DB::table('members')->where('vendor_id', $id)->where('user_id', $user_id)->first()->id)) {
			} else {
				$post1 = new Member;
				$post1->user_id = $user_id;
				$post1->vendor_id = $id;
				$post1->expense_type = 0;
				$msg = $post1->save();
			}

			$ar['pending'] = DB::select(DB::raw("SELECT a.id,a.status from invoice_main a WHERE a.vendor_id = '$id' AND a.user_id = '$request->member_id' AND a.status = 3"));
			if (empty($ar['pending'])) {
				$post = new Invoice_main;
				$post->vendor_id = $id;
				$post->user_id = $user_id;
				$post->member_selected = 1;
				$post->status = 3;
				$msg = $post->save();
				if ($msg) {
					$invoice_main_id = $post->id;
					DB::table('invoice_main')->where('vendor_id', $id)->where('id',  '!=', $invoice_main_id)->where('status', 3)->update(array('member_selected' => 0));
					$data['msg_en'] = array('text' => $this->__transEn('added_success'), 'cls' => 'text-success');
					$data['msg_ar'] = array('text' => $this->__transAr('added_success'), 'cls' => 'text-success');
					$data['status'] = 1;
					$data['invoice_id'] = $invoice_main_id;
				} else {

					$data['msg_en'] = array('text' => $this->__transEn('added_fail'), 'cls' => 'text-danger');
					$data['msg_ar'] = array('text' => $this->__transAr('added_fail'), 'cls' => 'text-danger');
					$data['status'] = 0;
				}
			} else {
				DB::table('invoice_main')->where('vendor_id', $id)->where('user_id', $request->member_id)->where('status', 3)->update(array('member_selected' => 1));
				DB::table('invoice_main')->where('vendor_id', $id)->where('user_id',  '!=', $request->member_id)->where('status', 3)->update(array('member_selected' => 0));
				$data['msg_en'] = array('text' => $this->__transEn('member_invoice_already_pending'), 'cls' => 'text-success');
				$data['msg_ar'] = array('text' => $this->__transAr('member_invoice_already_pending'), 'cls' => 'text-success');
				$data['status'] = 1;
			}
		} else {
			$data['msg_en'] = array('text' => $this->__transEn('member_not_found'), 'cls' => 'text-success');
			$data['msg_ar'] = array('text' => $this->__transAr('member_not_found'), 'cls' => 'text-success');
			$data['status'] = 0;
		}
		return $data;
	}



	//remove member from invoice
	public function invoice_member_remove(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$msg = DB::table('invoice_main')->where('vendor_id', $id)->where('status', 3)->update(array('member_selected' => 0));
		if ($msg) {
			$data['msg_en'] = array('text' => $this->__transEn('member_removed_sussessfully'), 'cls' => 'text-success');
			$data['msg_ar'] = array('text' => $this->__transAr('member_removed_sussessfully'), 'cls' => 'text-success');
			$data['status'] = 1;
		} else {

			$data['msg_en'] = array('text' =>  $this->__transEn('fail_to_remove_member'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' =>  $this->__transAr('fail_to_remove_member'), 'cls' => 'text-danger');
			$data['status'] = 0;
		}
		return $data;
	}

	//get product list for invoices
	public function invoice_products(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::id();
		}
		$data = array();
		$data['product_list'] =  DB::table('products')
			->select('products.id', 'products.name', 'products.price', 'products.barcode')
			->where('products.vendor_id', $id)
			->get();
		$data['product_list_status'] = 1;
		if (empty($data['product_list'])) {
			$data['product_list_status'] = 0;
			$data['msg_en'] = $this->__transEn('products_not_found');
			$data['msg_ar'] = $this->__transAr('products_not_found');
		}
		return $data;
	}
	//add product to invoice
	public function invoice_product_add(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$post = new Invoice_detail;
		$post->product_id = $request->product_id;
		$post->price = $request->price;
		$post->name = $request->product_name;
		$post->invoice_main_id = $request->invoice_main_id;
		$post->qty = $request->quantity;
		$post->unit = $request->unit;
		$post->amount = $request->amount;
		$post->offer_id = $request->offer_id;
		$msg = $post->save();
		if ($msg) {
			$data['msg_en'] = array('text' => $this->__transEn('added_success'), 'cls' => 'text-success');
			$data['msg_ar'] = array('text' => $this->__transAr('added_success'), 'cls' => 'text-success');
			$data['status'] = 1;
		} else {

			$data['msg_en'] = array('text' => $this->__transEn('added_fail'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('added_fail'), 'cls' => 'text-danger');
			$data['status'] = 0;
		}
		return $data;
	}

	//add product to invoice
	public function invoice_product_add_barcode(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}

		$product_data = Products::select('id', 'name', 'price')->where('barcode', $request->barcode)->where('vendor_id', $id)->where('status', 1)->first();
		if (!empty($product_data)) {

			$data = array();
			$post = new Invoice_detail;
			$post->product_id = $product_data->id;
			$post->price = $product_data->price;
			$post->name = $product_data->name;
			$post->invoice_main_id = $request->invoice_main_id;
			$post->qty = 1;
			$post->unit = "Pcs";
			$post->amount = $product_data->price;
			$post->offer_id = 0;
			$msg = $post->save();
			if ($msg) {
				$data['msg_en'] = array('text' => $this->__transEn('added_success'), 'cls' => 'text-success');
				$data['msg_ar'] = array('text' => $this->__transAr('added_success'), 'cls' => 'text-success');
				$data['status'] = 1;
			} else {

				$data['msg_en'] = array('text' => $this->__transEn('added_fail'), 'cls' => 'text-danger');
				$data['msg_ar'] = array('text' => $this->__transAr('added_fail'), 'cls' => 'text-danger');
				$data['status'] = 0;
			}
		} else {
			$data['msg_en'] = array('text' => $this->__transEn('product_not_found'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('product_not_found'), 'cls' => 'text-danger');
			$data['status'] = 0;
		}
		return $data;
	}
	//add product to invoice
	public function invoice_product_update(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$post = Invoice_detail::find($request->invoice_item_id);

		$post->price = $request->price;
		$post->qty = $request->quantity;
		$post->unit = $request->unit;
		$post->amount = $request->amount;
		$msg = $post->save();
		if ($msg) {
			$data['msg_en'] = array('text' => $this->__transEn('update_success'), 'cls' => 'text-success');
			$data['msg_ar'] = array('text' => $this->__transAr('update_success'), 'cls' => 'text-success');
			$data['status'] = 1;
		} else {

			$data['msg_en'] = array('text' => $this->__transEn('update_fail'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('update_fail'), 'cls' => 'text-danger');
			$data['status'] = 0;
		}
		return $data;
	}

	//delete product to invoice
	public function invoice_product_delete(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$msg = Invoice_detail::where('id', $request->invoice_item_id)->where('product_id', $request->product_id)->delete();
		if ($msg) {
			$data['msg_en'] = array('text' => $this->__transEn('delete_success'), 'cls' => 'text-success');
			$data['msg_ar'] = array('text' => $this->__transAr('delete_success'), 'cls' => 'text-success');
			$data['status'] = 1;
		} else {
			$data['msg_en'] = array('text' => $this->__transEn('delete_fail'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('delete_fail'), 'cls' => 'text-danger');
			$data['status'] = 0;
		}
		return $data;
	}

	//cart data
	public function cart_data(Request $request)
	{
		$data = array();
		$id = $request->user_id;;
		$data['days_alert'] = '5';
		$data['days_wait'] = '-3';
		if (isset(DB::table('subscribe_screen')->where('user_id', $id)->whereDate('created_at', Carbon::today())->first()->id)) {
			$data['today_alert']  = 0;
		} else {
			$data['today_alert']  = 1;
		}

		$data['user_membership'] = DB::select(DB::raw(
			"SELECT a.start_date,a.end_date,a.amount_paid,a.pkg_id, DATEDIFF(a.end_date, a.start_date) as remaining_days,b.name_en,b.name_ar
        	FROM subscription a	,package b		
        	WHERE a.pkg_id = b.id AND 
        	a.user_id='$id' AND a.status = 1"
		));

		$vendor_id = $request->user_id;
		//$user_id = $request->member_id;

		$data['tax_value'] = 15;
		$inv_id = 0;
		$data['cart_data'] =   DB::select(DB::raw("select a.id,a.user_id,(SELECT name FROM user_detail WHERE uid = a.user_id) AS member_name,a.total_amount,a.discount_invoice,a.tax,a.net_total FROM invoice_main a
        WHERE
        a.vendor_id = '$vendor_id' AND a.member_selected = 1 AND a.status = '3'"));
		$data['cart_data_status'] = 1;
		if (empty($data['cart_data'])) {
			$data['cart_data_status'] = 0;
			$data['msg_en'] = $this->__transEn('cart_data__not_found');
			$data['msg_ar'] = $this->__transAr('cart_data__not_found');
		}
		$data_inv = $data['cart_data'];
		foreach ($data_inv as $inv) {
			$inv_id = $inv->id;
		}

		$data['cart_items'] =   DB::select(DB::raw("select a.id,a.product_id,a.name,a.qty,a.unit,a.price,a.discount,a.amount,a.status FROM invoice_detail a
        WHERE a.invoice_main_id = '$inv_id' "));

		$data['cart_items_status'] = 1;
		if (empty($data['cart_items'])) {
			$data['cart_items_status'] = 0;
			$data['msg_en'] = $this->__transEn('cart_items_data__not_found');
			$data['msg_ar'] = $this->__transAr('cart_items_data__not_found');
		}
		$data['alerts_count'] = DB::table('alerts')->where('vendor_id', $vendor_id)->orwhere('alert_type', 3)->groupBy('inv_offer_id')->count();
		return $data;
	}

	//get vendor types for registration form
	public function vendor_types(Request $request)
	{
		$data = array();
		$data['vendor_types'] = DB::select(DB::raw("SELECT a.id,a.expense_name,a.expense_name_ar
        FROM expense_types a			
        WHERE a.status = 1 AND a.type = 1"));

		$data['vendor_types_status'] = 1;
		if (empty($data['vendor_types'])) {
			$data['vendor_types_status'] = 0;
			$data['msg_en'] = $this->__transEn('vendor_type_not_found');
			$data['msg_ar'] = $this->__transAr('vendor_type_not_found');
		}
		return $data;
	}

	public function products_chart(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$data['total_products'] = DB::table('products')->where('vendor_id', $id)->where('status', 1)->count();

		/*top product*/
		$data['top_products_sale'] = DB::table('products')
			->select(
				'products.*',
				DB::raw("
					(SELECT name FROM categories WHERE categories.id = products.category_id) as category_name
				"),
				DB::raw("
					(SELECT name_ar FROM categories WHERE categories.id = products.category_id) as category_name_ar
				"),
				DB::raw("
					(SELECT COUNT(invoice_detail.id) FROM invoice_detail WHERE invoice_detail.product_id = products.id) as sales 
				")
			)
			->where('products.vendor_id', $id)
			->where('products.status', 1)
			->get();
		$data['top_products_sale_status'] = 1;
		if ($data['top_products_sale']->count() <= 0) {
			$data['msg_en'] = $this->__transEn('record_not_found');
			$data['msg_ar'] = $this->__transAr('record_not_found');
			$data['top_products_sale_status'] = 0;
		}

		/*low products*/
		$data['low_products_sale'] = DB::table('products')
			->select(
				'products.*',
				DB::raw("
					(SELECT name FROM categories WHERE categories.id = products.category_id) as category_name
				"),
				DB::raw("
					(SELECT name_ar FROM categories WHERE categories.id = products.category_id) as category_name_ar
				"),
				DB::raw("
					(SELECT COUNT(invoice_detail.id) FROM invoice_detail WHERE invoice_detail.product_id = products.id) as sales
				"),
			)
			->where('products.vendor_id', $id)
			->where('products.status', 1)
			->get();
		$data['low_products_sale_status'] = 1;
		if ($data['low_products_sale']->count() <= 0) {
			$data['msg_en'] = $this->__transEn('record_not_found');
			$data['msg_ar'] = $this->__transAr('record_not_found');
			$data['low_products_sale_status'] = 0;
		}

		/*no products*/
		$product_ids = DB::table('invoice_main')
			->join('invoice_detail', 'invoice_main.id', '=', 'invoice_detail.invoice_main_id')
			->where('invoice_main.vendor_id', $id)
			->pluck('invoice_detail.product_id');

		$data['no_products_sale'] = DB::table('products')
			->where('products.vendor_id', $id)
			->where('products.status', 1)
			->whereNotIn('products.id', $product_ids)
			->get();
		$data['no_products_sale_status'] = 1;
		if ($data['no_products_sale']->count() <= 0) {
			$data['msg_en'] = $this->__transEn('record_not_found');
			$data['msg_ar'] = $this->__transAr('record_not_found');
			$data['no_products_sale_status'] = 0;
		}

		/*percentages*/
		if ($data['total_products'] > 0) {
			$topTag = $data['top_products_sale']->count() * 100 / $data['total_products'];
			$data['top_products_sale_percentage'] = round($topTag, 2);

			$lowTag = $data['low_products_sale']->count() * 100 / $data['total_products'];
			$data['low_products_sale_percentage'] = round($lowTag, 2);

			$noTag = $data['no_products_sale']->count() * 100 / $data['total_products'];
			$data['no_products_sale_percentage'] = round($noTag, 2);
		} else {
			$data['top_products_sale_percentage'] = 0;
			$data['low_products_sale_percentage'] = 0;
			$data['no_products_sale_percentage'] = 0;
		}
		return $data;
	}

	public function members_chart(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$data['members'] = DB::table('members')->where('vendor_id', $id)->count();
		$data['invoices'] = DB::table('invoice_main')->where('vendor_id', $id)->count();
		$data['sale_amount'] = DB::table('invoice_main')->where('vendor_id', $id)->sum('net_total');
		/*male sitting*/
		$menUser = DB::table('members')
			->join('user_detail', 'members.user_id', '=', 'user_detail.uid')
			->where('members.vendor_id', $id)
			->where('user_detail.gender', 'male')
			->get();
		$data['men'] = $menUser->count();
		$menInv = $menInvAmount = 0;
		foreach ($menUser as $value) {
			$menInv += DB::table('invoice_main')->where('user_id', $value->user_id)->count();
			$menInvAmount += DB::table('invoice_main')->where('user_id', $value->user_id)->sum('net_total');
		}
		$data['men_invoices'] = $menInv;
		$data['men_invoices_amount'] = $menInvAmount;

		/*female sitting*/
		$womenUser = DB::table('members')
			->join('user_detail', 'members.user_id', '=', 'user_detail.uid')
			->where('members.vendor_id', $id)
			->where('user_detail.gender', 'female')
			->get();
		$data['women'] = $womenUser->count();
		$womenInv = $womenInvAmount = 0;
		foreach ($womenUser as $row) {
			$womenInv += DB::table('invoice_main')->where('user_id', $row->user_id)->count();
			$womenInvAmount += DB::table('invoice_main')->where('user_id', $row->user_id)->sum('net_total');
		}
		$data['women_invoices'] = $womenInv;
		$data['women_invoices_amount'] = $womenInvAmount;

		/*products*/
		/*		$data['products'] = DB::table('products')
		->select(
			'products.*',
			DB::raw("
				(SELECT name FROM categories WHERE categories.id = products.category_id) as category_name
			"),
			DB::raw("
				(SELECT name_ar FROM categories WHERE categories.id = products.category_id) as category_name_ar
			"),
			DB::raw("
				(SELECT COUNT(invoice_detail.id) FROM invoice_detail WHERE invoice_detail.product_id = products.id) as sales 
			")
		)
		->where('vendor_id', $id)
		->where('status', 1)
		->limit(5)
		->get();
		$data['products_status'] = 1;
		if($data['products']->count() <= 0){
			$data['msg_en'] = $this->__transEn('record_not_found');
			$data['msg_ar'] = $this->__transAr('record_not_found');
			$data['products_status'] = 0;
		}*/

		/*womens ages*/
		$w_min = DB::table('members')->join('user_detail', 'members.user_id', '=', 'user_detail.uid')
			->where('members.vendor_id', $id)->where('user_detail.gender', 'female')->min('age');
		$w_max = DB::table('members')->join('user_detail', 'members.user_id', '=', 'user_detail.uid')
			->where('members.vendor_id', $id)->where('user_detail.gender', 'female')->max('age');
		$data['women_ages'] = $w_min . " - " . $w_max;

		/*men ages*/
		$m_min = DB::table('members')->join('user_detail', 'members.user_id', '=', 'user_detail.uid')
			->where('members.vendor_id', $id)->where('user_detail.gender', 'male')->min('age');
		$m_max = DB::table('members')->join('user_detail', 'members.user_id', '=', 'user_detail.uid')
			->where('members.vendor_id', $id)->where('user_detail.gender', 'male')->max('age');
		$data['men_ages'] = $m_min . " - " . $m_max;




		$data['member_list'] =   DB::select(DB::raw("select b.user_id,a.id,a.uid,a.name,
		(SELECT COALESCE(count(id),0) FROM invoice_main WHERE vendor_id = '$id'  AND user_id = a.uid) AS member_invoices
		,(SELECT COALESCE(SUM(net_total),0) FROM invoice_main WHERE vendor_id = '$id' AND user_id = a.uid) AS member_total FROM user_detail a
        LEFT JOIN  members b ON b.user_id = a.uid 			 
        WHERE
        b.vendor_id = '$id' ORDER BY member_total DESC LIMIT 15"));

		$data['member_list_status'] = 1;
		if (empty($data['member_list'])) {
			$data['member_list_status'] = 0;
			$data['msg_en'] = $this->__transEn('member_list_not_found');
			$data['msg_ar'] = $this->__transAr('member_list_not_found');
		}






		return $data;
	}

	// 
	public function offer_create(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$memberAry = "";
		if ($request->member_check == 1) {
			$memberAry2 = Member::where('vendor_id', $id)->pluck('user_id')->toArray();
		} else {
			$memberAry = $request->member_id;
			$memberIds = str_replace('[', "", $memberAry);
			$members = str_replace(']', "", $memberIds);
			$memberAry2 = explode(',', $members);
		}
		$post = new Offers;
		$post->vendor_id = intval($id);
		$post->offer_on = intval($request->offer_on);
		$post->description = $request->description;
		$post->amount = 0;
		$post->discount_type = 'General';
		$post->expiry_date = Carbon::parse($request->expiry_date);
		$post->member_check = $request->member_check;
		$post->product_id = 0;
		$msg = $post->save();
		/*users*/

		foreach ($memberAry2 as $key => $value) {
			$post2 = new Offer_users;
			$post2->offer_id = $post->id;
			$post2->user_id = intval($value);
			$msg = $post2->save();
		}

		if ($msg) {
			foreach ($memberAry2 as $key => $value) {
				$post2 = new Alerts;
				$post2->user_id = $value;
				$post2->vendor_id = intval($id);
				$post2->ref_id = $post->id;
				$post2->title = "New Offer";
				$post2->discription = $request->description;
				$post2->alert_type = 2;
				$msg2 = $post2->save();
			}
			$data['msg_en'] = $this->__transEn('created_success');
			$data['msg_ar'] = $this->__transAr('created_success');
			$data['status'] = 1;
		} else {
			$data['msg_en'] = $this->__transEn('something_went_wrong');
			$data['msg_ar'] = $this->__transAr('something_went_wrong');
			$data['status'] = 0;
		}
		return $data;
	}

	// 
	public function offer_total(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		/*offers*/
		$data['offers'] = Offers::where('vendor_id', $id)
			->select(
				'offers.*',
				DB::raw("
					DATEDIFF(offers.expiry_date, offers.created_at) as remaining_days
				")
			)
			->where('expiry_date', '>', Date('Y-m-d'))
			->where('offer_status', 1)
			->get();
		$data['total_offers'] = count($data['offers']);
		$data['offers_status'] = 1;
		if (empty($data['offers'])) {
			$data['msg_en'] = $this->__transEn('record_not_found');
			$data['msg_ar'] = $this->__transAr('record_not_found');
			$data['offers_status'] = 0;
		}
		return $data;
	}

	/*offer members*/
	public function offer_members(Request $request)
	{
		$data = array();
		if (isset($request->offer_id) && !empty($request->offer_id)) {
			$members = Offer_users::where('offer_id', $request->offer_id)->pluck('user_id');
			$data['offers_members'] = DB::table('user_detail')
				->select(
					'uid',
					'name',
					'gender',
					'age'
				)
				->whereIn('uid', $members)
				->get();
			$data['offers_members_status'] = 1;
			if (empty($data['offers_members'])) {
				$data['msg_en'] = $this->__transEn('record_not_found');
				$data['msg_ar'] = $this->__transAr('record_not_found');
				$data['offers_members_status'] = 0;
			}
		} else {
			$data['msg_en'] = $this->__transEn('id_not_found');
			$data['msg_ar'] = $this->__transAr('id_not_found');
			$data['offers_members_status'] = 0;
		}
		return $data;
	}

	//get user subscription detail
	public function vendor_membership(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$data['vendor_membership'] = DB::select(DB::raw(
			"SELECT a.start_date,a.end_date,a.amount_paid, DATEDIFF(a.end_date, a.start_date) as remaining_days
        	FROM subscription a			
        	WHERE
        	a.user_id='$id' AND a.status = 1"
		));
		$data['vendor_membership_status'] = 1;
		if (empty($data['vendor_membership'])) {
			$data['vendor_membership_status'] = 0;
			$data['msg_en'] = $this->__transEn('memberships_not_found');
			$data['msg_ar'] = $this->__transAr('memberships_not_found');
		}
		return $data;
	}

	// vendor memberships
	public function renew_membership(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		if ($request->card_no == '0000000000') {
			if (empty($request->pkg_id)) {
				$data['msg_en'] = $this->__transEn('please_select_package');
				$data['msg_ar'] = $this->__transAr('please_select_package');
				$data['status'] = 0;
			} else {
				$day = $request->pkg_days;

				$newdate = date('Y-m-d', strtotime($request->start_date . ' + ' . $day . ' days'));
				//$newdate = $request->start_date, strtotime("+$day days");
				$post = new Subscription;
				$post->user_id = $id;
				$post->pkg_id = intval($request->pkg_id);
				$post->amount_paid = $request->amount_paid;
				$post->start_date = date('Y-m-d', strtotime($request->start_date));
				$post->end_date = $newdate;
				$msg = $post->save();
				if ($msg) {
					DB::table('subscription')->where('id', '!=', $post->id)->where('user_id', $request->user_id)->update(array('status' => 0));
					$data['msg_en'] = $this->__transEn('renewed_successfully');
					$data['msg_ar'] = $this->__transAr('renewed_successfully');
					$data['status'] = 1;
					$data['exp_date'] = $newdate;
				} else {
					$data['msg_en'] = $this->__transEn('renew_fail');
					$data['msg_ar'] = $this->__transAr('renew_fail');
					$data['status'] = 0;
				}
			}
		} else {
			$data['msg_en'] = $this->__transEn('credit_card_payment_not_available');
			$data['msg_ar'] = $this->__transAr('credit_card_payment_not_available');
			$data['status'] = 0;
		}
		return $data;
	}

	//view vendor alerts
	public function veiw_alerts(Request $request)
	{
		$data = array();
		if ($request->apptype == "app") {
			/*for user panel*/
			if (!empty($request->user_id)) {
				$data['alerts'] = DB::select(DB::raw("
					SELECT * FROM alerts a			
		        	WHERE
		        	a.user_id='$request->user_id' OR 
		        	a.alert_type=3
		        "));
			}

			/*for business panel*/ elseif (!empty($request->vendor_id)) {
				$data['alerts'] = DB::select(DB::raw("
					SELECT * FROM alerts a
		        	WHERE
		        	a.vendor_id='$request->vendor_id' OR 
		        	a.alert_type=3 
		        	
		        "));
			}
		} else {
			/*for web version*/
		}
		$data['alert_count'] = count($data['alerts']);
		$data['alerts_status'] = 1;
		if (empty($data['alerts'])) {
			$data['alerts_status'] = 0;
			$data['msg_en'] = $this->__transEn('record_not_found');
			$data['msg_ar'] = $this->__transAr('record_not_found');
		}
		return $data;
	}



	public function alert_read(Request $request)
	{
		$data = array();
		$data = [
			'alert_status' => '1',
		];
		Alerts::where('id', $request->id)->update($data);
		$data['msg_en'] = $this->__transEn('read_success');
		$data['msg_ar'] = $this->__transAr('read_success');
		return $data;
	}

	public function pay_invoice_user(Request $request)
	{
		$data = array();
		$data2 = [
			'paid_status' => '1',
			'payment_type' => $request->payment_type
		];
		if ($request->has('attachments') && !empty($request->attachments) && $request->payment_type == 2) :
			$file = $request->file('attachments');
			// $files = [];
			// foreach ($request->file('attachments') as $file) {
			$name = 'project/invoice_attachments/' . Str::random(30) . "." . $file->getClientOriginalExtension();
			$file->move(public_path('project/invoice_attachments'), $name);
			// 	$files[] = $name;
			// }
			$data2['attachments'] = $name;
		endif;
		Invoice_main::where('id', $request->id)->update($data2);
		$data['msg_en'] = $this->__transEn('invoice_paid_succussfully');
		$data['msg_ar'] = $this->__transAr('invoice_paid_succussfully');
		$data['status'] = 1;
		return $data;
	}

	//paid invoice
	public function pay_invoice(Request $request)
	{
		$data = array();
		$data = [
			'paid_status' => '1',
		];
		Invoice_main::where('id', $request->id)->update($data);
		$data['msg_en'] = $this->__transEn('invoice_paid_succussfully');
		$data['msg_ar'] = $this->__transAr('invoice_paid_succussfully');
		return $data;
	}

	public function vendor_approve(Request $request)
	{
		$data = array();
		$data = [
			'is_approve' => 1,
		];
		Invoice_main::where('id', $request->id)->update($data);
		$data['msg_en'] = $this->__transEn('approved successfully');
		$data['msg_ar'] = $this->__transAr('approved successfully');
		$data['status'] = 1;
		return $data;
	}

	public function vendor_barcode(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		if (isset(DB::table('vendor_detail')->where('qrcode', $request->qrcode)->where('vendor_status', 1)->first()->id)) {
			$vendor_id = DB::table('vendor_detail')->where('qrcode', $request->qrcode)->where('vendor_status', 1)->first()->uid;
			$data['vendor_logo_url'] = "https://sarfapp.com/uploads/images/vendor/";
			$data['vendor_detail'] =  DB::table('vendor_detail')->where('qrcode', $request->qrcode)->where('vendor_status', 1)->first();
			if (isset(DB::table('members')->where('vendor_id', $vendor_id)->where('user_id', $id)->first()->id)) {
				$data['already_member'] = 1;
			} else {
				$data['already_member'] = 0;
			}
			$data['msg_en'] = array('text' => $this->__transEn('member_found'), 'cls' => 'text-success');
			$data['msg_ar'] = array('text' => $this->__transAr('member_found'), 'cls' => 'text-success');
			$data['status'] = 1;
		} else {
			$data['msg_en'] = array('text' => $this->__transEn('member_not_found'), 'cls' => 'text-success');
			$data['msg_ar'] = array('text' => $this->__transAr('member_not_found'), 'cls' => 'text-success');
			$data['status'] = 0;
		}
		return $data;
	}
}
