<?php

namespace App\Http\Controllers\api;

use Illuminate\Support\Str;
use App\Http\Controllers\Controller;
use App\Models\Project\Budget;
use App\Models\Project\Colors;
use App\Models\Admin\User;
use App\Models\Project\Alerts;
use App\Models\Project\Vendor;
use App\Models\Project\Member;
use App\Models\Project\Expense_type;
use App\Models\Project\Expense_types_user;
use App\Models\Project\Offers;
use App\Models\Project\Subscribe_screen;
use App\Models\Project\Expenses;
use App\Models\Project\Invoice_attachment;
use App\Models\Project\Invoice_main;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Session;

use App\Traits\ApiLanguageTrait;
use App\Traits\NearByTrait;
use App\Models\Project\Offer_users;

class HomeController extends Controller
{
	use ApiLanguageTrait, NearByTrait;
	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function index(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$data['vendor_image_url'] = "https://sarfapp.com/images/vendors/";
		$data['days_alert'] = '7';
		$data['days_wait'] = "-3";
		$data['budget_id'] = (string)DB::table('budgets')->where('user_id', $id)->where('budget_type', 1)->first()->id;
		$salary_id = (string)DB::table('budgets')->where('user_id', $id)->where('budget_type', 1)->first()->id;
		if (isset(DB::table('subscribe_screen')->where('user_id', $id)->whereDate('created_at', Carbon::today())->first()->id)) {
			$data['today_alert']  = 0;
		} else {
			$data['today_alert']  = 1;
		}

		$data['user_membership'] = DB::select(DB::raw(
			"SELECT a.start_date,a.end_date,a.amount_paid,a.pkg_id, DATEDIFF(a.end_date, now()) as remaining_days,b.name_en,b.name_ar
        	FROM subscription a	,package b		
        	WHERE a.pkg_id = b.id AND 
        	a.user_id='$id' AND a.status = 1"
		));
		//$data['salary'] = "5000";
		if (isset(DB::table('budgets')->where('user_id', $id)->where('budget_type', 1)->where('budget_status', 1)->first()->budget_amount)) {
			$data['salary'] = (string)DB::table('budgets')->where('user_id', $id)->where('budget_type', 1)->first()->budget_amount;
		} else {
			$data['salary'] = "0";
		}
		$data['salary_chart']  = array();
		$data['salary_chart']  = DB::select(DB::raw("SELECT b.id,b.budget_amount,
	 (SELECT SUM(net_total) FROM invoice_main WHERE budget_id = b.id AND user_id = '$request->user_id' AND is_reset = 0) as total_expenses  FROM budgets b WHERE  b.budget_type = 1 AND b.user_id = '$request->user_id'  "));
		$data['salary_chart_status'] = 1;
		if (empty($data['salary_chart'])) {
			//$data['salary_chart']['value'] = round($data['salary_chart']['value'],2);
			$data['salary_chart_status'] = 0;
			$data['msg_en'] = array('text' => 'Sorry Salary chart not found', 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => 'Sorry Salary chart not found ar', 'cls' => 'text-danger');
		}

		$budget_list = Budget::query()->select('id', 'project_number', 'budget_name', 'budget_amount')->where('user_id', $request->user_id)->where('budget_type', 2)->where('budget_status', 1)->get();
		$data['budget_list'] = [];
		foreach ($budget_list as $key => $bud) {
			$data['budget_list'][] = $bud;
			$bud_id = $bud->id;
			//$data['budget_list'][$key]['budget_chart'] = array();
			$data['budget_list'][$key]['total_expenses'] = DB::table('invoice_main')->where('user_id', $request->user_id)->where('is_reset', 0)->where('budget_id', $bud_id)->sum('net_total');
		}
		$data['budget_list_status'] = 1;
		if (empty($data['budget_list'])) {
			$data['budget_list_status'] = 0;
			$data['msg_en'] = array('text' => 'Sorry budget list not found', 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => 'Sorry budget list not found ar', 'cls' => 'text-danger');
		}
		$salary_id = (string)DB::table('budgets')->where('user_id', $id)->where('budget_type', 1)->first()->id;
		$data['expense_type'] =   DB::select(DB::raw("SELECT a.id,a.expense_name,a.expense_name_ar,a.color,
		(SELECT COALESCE(SUM(net_total),0) FROM invoice_main WHERE expense_type = a.id AND user_id = '$request->user_id' AND is_reset = 0 AND budget_id = '$salary_id') AS total_amount
		 FROM expense_types a WHERE a.type = 1  AND a.status = 1"));
		$data['expense_type_status'] = 1;
		if (empty($data['expense_type'])) {
			$data['expense_type_status'] = 0;
			$data['msg_en'] = array('text' => 'Sorry expense not found', 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => 'Sorry expense not found ar', 'cls' => 'text-danger');
		}

		$data['expense_type_user'] =   DB::select(DB::raw("SELECT a.id,a.user_id,a.expense_name,a.color,(SELECT COALESCE(SUM(net_total),0) FROM invoice_main WHERE expense_type = a.id AND user_id = '$request->user_id' AND is_reset = 0 AND budget_id = '$salary_id') AS total_amount,a.budget_id,(SELECT budget_name FROM budgets WHERE id = a.budget_id) AS budget_name FROM expense_types a WHERE a.type = 2 AND a.user_id = '$request->user_id' AND a.status = 1"));
		$data['expense_type_user_status'] = 1;
		if (empty($data['expense_type_user'])) {
			$data['expense_type_user_status'] = 0;
			$data['msg_en'] = array('text' => 'Sorry user expense not found ', 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => 'Sorry user expense not found ar', 'cls' => 'text-danger');
		}

		$data['vendor_logo_url'] = "https://sarfapp.com/uploads/images/vendor/";
		$data['vendors'] =   DB::select(DB::raw("SELECT * FROM vendor_detail a WHERE NOT EXISTS
        (
        SELECT  vendor_id 
        FROM    members b
        WHERE   b.vendor_id = a.uid AND user_id = '$request->user_id'
        ) AND a.vendor_status = 1 AND business_type = 0"));
		$data['vendors_status'] = 1;
		if (empty($data['vendors'])) {
			$data['vendors_status'] = 0;
			$data['msg_en'] = array('text' => 'Sorry vendors not found ', 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => 'Sorry vendors not found ar', 'cls' => 'text-danger');
		}

		$data['colors_list'] =  DB::select(DB::raw("SELECT id,c_code FROM colors WHERE status = 1 "));
		$data['colors_list_status'] = 1;
		if (empty($data['colors_list'])) {
			$data['colors_list_status'] = 0;
			$data['msg_en'] = array('text' => 'Sorry color list not found', 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => 'Sorry color list not found ar', 'cls' => 'text-danger');
		}
		$data['budget_list_new'] =  Budget::query()
			->select('id', 'project_number', 'budget_name')->where('user_id', $request->user_id)->get();
		$data['project_count'] = Budget::where(['user_id'=>$request->user_id])
		->whereNotNull('project_number')
		->count();
		$data['alerts_count'] = DB::table('alerts')->where('user_id', $id)->orwhere('alert_type', 3)->count();
		return $data;
	}

	public function budget_detail_index(Request $request)
	{
		$data = array();
		if ($request->apptype == "app") {
			$id = $request->user_id;
			$data['user'] = User::select('id', 'name', 'username', 'mobile','tax_number')->find($id);
		} else {
			$id = Auth::user()->id;
			$data['user'] = User::select('id', 'name', 'username', 'mobile')->find($id);
		}
		$data['vendor_image_url'] = "https://sarfapp.com/images/vendors/";
		$data['days_alert'] = '7';
		$data['days_wait'] = "-3";

		if (isset(DB::table('subscribe_screen')->where('user_id', $id)->whereDate('created_at', Carbon::today())->first()->id)) {
			$data['today_alert']  = 0;
		} else {
			$data['today_alert']  = 1;
		}

		$data['user_membership'] = DB::select(DB::raw(
			"SELECT a.start_date,a.end_date,a.amount_paid,a.pkg_id, DATEDIFF(a.end_date, now()) as remaining_days,b.name_en,b.name_ar
        	FROM subscription a	,package b		
        	WHERE a.pkg_id = b.id AND 
        	a.user_id='$id' AND a.status = 1"
		));
		//$data['salary'] = "5000";
		$data['salary'] = (string) DB::table('budgets')->where(['user_id'=> $request->user_id])->sum('budget_amount') ?? 0;
		if($request->has('budget_id') && !empty($request->budget_id)) {
			$data['salary'] = (string) DB::table('budgets')->where(['id'=> $request->budget_id])->first()->budget_amount ?? 0;
		}
		
		$data['salary_chart']  = array();
		$data['salary_chart']  = DB::select(DB::raw("SELECT b.id,b.budget_amount, (SELECT SUM(net_total) FROM invoice_main WHERE budget_id = b.id AND user_id = '$request->user_id' AND is_reset = 0) as total_expenses  FROM budgets b WHERE  b.user_id = '$request->user_id' AND b.budget_type = 2 AND b.budget_status = 1"));
		$data['salary_chart_status'] = 1;
		if (empty($data['salary_chart'])) {
			//$data['salary_chart']['value'] = round($data['salary_chart']['value'],2);
			$data['salary_chart_status'] = 0;
			$data['msg_en'] = array('text' => 'Sorry Salary chart not found', 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => 'Sorry Salary chart not found ar', 'cls' => 'text-danger');
		}

		$budget_list = Budget::query()->select('id', 'project_number', 'budget_name', 'budget_amount')->where(['user_id'=> $request->user_id, 'budget_type'=> 2, 'budget_status'=> 1])->get();
		$data['budget_list'] = [];
		foreach ($budget_list as $key => $bud) {
			$data['budget_list'][] = $bud;
			$bud_id = $bud->id;
			//$data['budget_list'][$key]['budget_chart'] = array();
			if ($request->has('budget_id') && !empty($request->budget_id)) {
				$data['budget_list'][$key]['total_expenses'] = DB::table('invoice_main')->where('user_id', $request->user_id)->where('is_reset', 0)->where('budget_id', $bud_id)->sum('net_total');
			} else{
				$data['budget_list'][$key]['total_expenses'] = DB::table('invoice_main')->where('user_id', $request->user_id)->where('is_reset', 0)->sum('net_total');
			}
		}
		$data['budget_list_status'] = 1;
		if (empty($data['budget_list'])) {
			$data['budget_list_status'] = 0;
			$data['msg_en'] = array('text' => 'Sorry budget list not found', 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => 'Sorry budget list not found ar', 'cls' => 'text-danger');
		}

		$whereBudget = "";
		if ($request->has('budget_id') && !empty($request->budget_id)) {
			$whereBudget = "AND budget_id = '$request->budget_id'";
		}
		$data['expense_type'] = DB::select(DB::raw("SELECT a.id,a.expense_name,a.expense_name_ar,a.color, (SELECT COALESCE(SUM(net_total),0) FROM invoice_main WHERE expense_type = a.id AND user_id = $request->user_id AND is_reset = 0 $whereBudget) AS total_amount FROM expense_types a WHERE a.type = 1 AND a.status = 1"));

		$data['expense_type_status'] = 1;
		if (empty($data['expense_type'])) {
			$data['expense_type_status'] = 0;
			$data['msg_en'] = array('text' => 'Sorry expense not found', 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => 'Sorry expense not found ar', 'cls' => 'text-danger');
		}

		$whereBudget = "";
		$whereBudget2 = "";
		if ($request->has('budget_id') && !empty($request->budget_id)) {
			$whereBudget = "AND budget_id = '$request->budget_id'";
			$whereBudget2 = " AND a.budget_id = '$request->budget_id'";
		}
		$data['expense_type_user'] = DB::select(DB::raw("SELECT a.id,a.user_id,a.expense_name,a.color,(SELECT COALESCE(SUM(net_total),0) FROM invoice_main WHERE expense_type = a.id AND user_id = $request->user_id AND is_reset = 0 $whereBudget) AS total_amount, a.budget_id, (SELECT budget_name FROM budgets WHERE id = a.budget_id) AS budget_name FROM expense_types a WHERE a.type = 2 AND a.user_id = $request->user_id$whereBudget2 AND a.status = 1"));
		$data['expense_type_user_status'] = 1;
		if (empty($data['expense_type_user'])) {
			$data['expense_type_user_status'] = 0;
			$data['msg_en'] = array('text' => 'Sorry user expense not found ', 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => 'Sorry user expense not found ar', 'cls' => 'text-danger');
		}

		$data['colors_list'] = DB::select(DB::raw("SELECT id,c_code FROM colors WHERE status = 1 "));
		$data['colors_list_status'] = 1;
		if (empty($data['colors_list'])) {
			$data['colors_list_status'] = 0;
			$data['msg_en'] = array('text' => 'Sorry color list not found', 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => 'Sorry color list not found ar', 'cls' => 'text-danger');
		}
		$data['budget_list_new'] = Budget::query()->select('id', 'project_number', 'budget_name')->where('user_id', $request->user_id)->get();

		$data['project_count'] = Budget::where(['user_id'=>$request->user_id])
		->whereNotNull('project_number')
		->count();
		
		$whereData = ['user_id' => $request->user_id, 'is_reset' => 0];
		if ($request->has('budget_id') && !empty($request->budget_id)) {
			$whereData['budget_id'] = $request->budget_id;
		}
		$data['total_invoices'] = Invoice_main::where($whereData)->count();
		$data['total_expenses'] = Invoice_main::where($whereData)->sum('net_total');
		return $data;
	}

	//view profile
	public function profile_edit(Request $request)
	{
		$data = array();
		$post = Budget::find($request->id);
		$post->budget_name = strip_tags($request->budget_name);
		$post->budget_amount = intval($request->budget_amount);
		$msg = $post->save();
		if ($msg) {
			$data['msg_en'] = array('text' => $this->__transEn('update_success'), 'cls' => 'success');
			$data['msg_ar'] = array('text' => $this->__transAr('update_success'), 'cls' => 'success');
			$data['status'] = 1;
		} else {
			$data['msg_en'] = array('text' => $this->__transEn('update_fail'), 'cls' => 'error');
			$data['msg_ar'] = array('text' => $this->__transAr('update_fail'), 'cls' => 'error');
			$data['status'] = 0;
		}

		return $data;
	}
	//edit profile info
	/*public function profile_edit(Request $request){
		$data = array();
	  	$post = Budget::find($request->id);
	  	$post->budget_name = strip_tags($request->budget_name);
	  	$post->budget_amount = intval($request->budget_amount);
	  	$msg = $post->save();
	  	if ($msg) {
			$data['msg_en'] = array('text' => 'Updated successfully', 'cls' => 'success');
			$data['msg_ar'] = array('text' => 'Updated successfully', 'cls' => 'success');
			$data['status'] = 1;
	  	}else{
	  		$data['msg_en'] = array('text' => 'Updation Fail', 'cls' => 'error');
	  		$data['msg_ar'] = array('text' => 'Updation Fail', 'cls' => 'error');
	  		$data['status'] = 0;
	  	}
		
	  	return $data;
	}
	
	//update profile info
	public function profile_update(Request $request){
		$data = array();
	  	$post = Budget::find($request->id);
	  	$post->budget_name = strip_tags($request->budget_name);
	  	$post->budget_amount = intval($request->budget_amount);
	  	$msg = $post->save();
	  	if ($msg) {
			$data['msg_en'] = array('text' => 'Updated successfully', 'cls' => 'success');
			$data['msg_ar'] = array('text' => 'Updated successfully', 'cls' => 'success');
			$data['status'] = 1;
	  	}else{
	  		$data['msg_en'] = array('text' => 'Updation Fail', 'cls' => 'error');
	  		$data['msg_ar'] = array('text' => 'Updation Fail', 'cls' => 'error');
	  		$data['status'] = 0;
	  	}
	  	return $data;
	}*/

	//get user data for more menu
	public function user_more(Request $request)
	{
		$data = array();
		$language = $request->language;

		$data['subscription'] = "240 days remaining";
		$data['user_image_url'] = "https://sarfapp.com/uploads/users/";

		$data['user_data'] = DB::select(DB::raw("SELECT a.id,b.name,a.image,b.qrcode
        FROM users a
		LEFT JOIN  user_detail b ON a.id = b.uid			
        WHERE
        a.id = '$request->user_id' "));

		$data['user_data_status'] = 1;
		if (empty($data['user_data'])) {
			$data['user_data_status'] = 0;
			$data['msg_en'] = $this->__transEn('user_not_found');
			$data['msg_ar'] = $this->__transAr('user_not_found');
		}
		return $data;
	}

	//add vendor to members table
	public function member_add(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::id();
		}
		$data = array();
		$post = new Member;
		$post->user_id = $id;
		$post->vendor_id = $request->member_id;
		$post->expense_type = $request->member_type;
		$msg = $post->save();
		if ($msg) {
			$data['msg_en'] = array('text' => $this->__transEn('saved_successfully'), 'cls' => 'success');
			$data['msg_ar'] = array('text' => $this->__transAr('saved_successfully'), 'cls' => 'success');

			$data['status'] = 1;
		} else {
			$data['msg_en'] = array('text' => $this->__transEn('not_added'), 'cls' => 'error');
			$data['msg_ar'] = array('text' => $this->__transAr('not_added'), 'cls' => 'error');
			$data['status'] = 0;
		}
		return $data;
	}

	//get member list
	public function members_list(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::id();
		}
		$data = array();
		$data['members_list'] =  DB::table('members')
			->join('vendor_detail', 'members.user_id', '=', 'vendor_detail.uid')
			->select('members.*', 'vendor_detail.*')
			->where('members.user_id', $id)
			->get();
		$data['members_status'] = 1;
		if (empty($data['members_list'])) {
			$data['members_status'] = 0;
			$data['msg_en'] = $this->__transEn('members_not_found');
			$data['msg_ar'] = $this->__transAr('members_not_found');
		}
		return $data;
	}
	//get member list of user
	public function members_user(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::id();
		}
		$data = array();
		$data['vendor_logo_url'] = "https://sarfapp.com/uploads/images/vendor/";
		$data['members_list'] =  DB::table('members')
			->join('vendor_detail', 'members.vendor_id', '=', 'vendor_detail.uid')
			->join('expense_types', 'members.expense_type', '=', 'expense_types.id')
			->select('members.*', 'vendor_detail.*', 'expense_types.expense_name', 'expense_types.expense_name_ar')
			->where('members.user_id', $id)
			->get();
		$data['members_status'] = 1;
		if (empty($data['members_list'])) {
			$data['members_status'] = 0;
			$data['msg_en'] = $this->__transEn('members_not_found');
			$data['msg_ar'] = $this->__transAr('members_not_found');
		}
		return $data;
	}

	//get member list of vendor
	public function members_vendor(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::id();
		}
		$data = array();
		$data['members_list'] =  DB::table('members')
			->join('user_detail', 'members.user_id', '=', 'user_detail.uid')
			->join('users', 'members.user_id', '=', 'users.id')
			->select('members.user_id', 'user_detail.name', 'users.username')
			->where('members.vendor_id', $id)
			->get();
		foreach ($data['members_list'] as $key => $value) {
			// $value->expense_types = Expense_type::select("expense_name", "expense_name_ar")->where(['type'=>1, 'status'=>1])->withCount('invoices')->get();
			$value->expense_types = Expense_type::select("expense_name", "expense_name_ar")->where(['user_id'=>$value->user_id, 'status'=>1])->withCount('invoices')->get();
		}
		$data['members_status'] = 1;
		if (empty($data['members_list'])) {
			$data['members_status'] = 0;
			$data['msg_en'] = $this->__transEn('members_not_found');
			$data['msg_ar'] = $this->__transAr('members_not_found');
		}
		return $data;
	}

	//get user subscription detail
	public function user_subscribe(Request $request)
	{
		$data = array();
		//$language = $request->language;
		//$data['subscription'] = "240 days remaining";
		$data['user_subscribe'] = DB::select(DB::raw("SELECT a.start_date,a.end_date,a.amount_paid,a.type,a.label_en,a.label_ar,(SELECT membership_note FROM setting WHERE id = 1) AS note_en,(SELECT membership_note FROM setting WHERE id = 1) AS note_ar
        FROM subscription a			
        WHERE
        a.user_id = '$request->user_id' AND a.status = 1"));

		$data['user_subscribe_status'] = 1;
		if (empty($data['user_subscribe'])) {
			$data['user_subscribe_status'] = 0;
			$data['msg_en'] = $this->__transEn('subscription_notfound');
			$data['msg_ar'] = $this->__transAr('subscription_notfound');
		}
		return $data;
	}

	//get packages list for subscription
	public function packages(Request $request)
	{
		$data = array();
		$data['packages'] = DB::select(DB::raw("SELECT a.id,a.name_en,a.name_ar,a.amount,a.duration
        FROM package a			
        WHERE a.status = 1"));

		$data['packages_status'] = 1;
		if (empty($data['packages'])) {
			$data['packages_status'] = 0;
			$data['msg_en'] = $this->__transEn('packages_not_found');
			$data['msg_ar'] = $this->__transAr('packages_not_found');
		}
		return $data;
	}

	//get user_offers list for
	public function user_offers(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::id();
		}
		$data = array();
		$vendor_id = getAny('vendor_id', 'members', 'user_id', $id);
		$data['business_name'] = getAny('name', 'vendor_detail', 'uid', $vendor_id);
		/*looping*/
		$data['user_offers'] = DB::table('offers')
			->join('offer_users', 'offers.id', '=', 'offer_users.offer_id')
			->select(
				'offers.*',
				DB::raw("
					DATEDIFF(offers.expiry_date, offers.created_at) as remaining_days
				"),
			)
			->where('offers.expiry_date', '>', Date('Y-m-d'))
			->where('offers.offer_status', 1)
			->where('offer_users.user_id', $id)
			->get();
		$data['user_offes_status'] = 1;
		if ($data['user_offers']->count() == 0) {
			$data['msg_en'] = $this->__transEn('record_not_found');
			$data['msg_ar'] = $this->__transAr('record_not_found');
			$data['user_offes_status'] = 0;
		}
		return $data;
	}

	public function general_all_offers(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::id();
		}
		$data = array();
		$today = Date('Y-m-d');
		$data['general_offers'] = DB::table('offers')
			->join('offer_users', 'offers.id', '=', 'offer_users.offer_id')
			->join('vendor_detail', 'offers.vendor_id', '=', 'vendor_detail.uid')
			->select(
				'offers.*',
				DB::raw("
					DATEDIFF(offers.expiry_date, offers.created_at) as remaining_days
				"),
				'vendor_detail.name',
			)
			->where('offers.expiry_date', '>', Date('Y-m-d'))
			->where('offers.offer_status', 1)
			->where('offer_users.user_id', $id)
			->get();
		$data['total_offers'] = $data['general_offers']->count();
		$data['offers_status'] = 1;
		if ($data['total_offers'] == 0) {
			$data['msg_en'] =  $this->__transEn('record_not_found');
			$data['msg_ar'] =  $this->__transAr('record_not_found');
			$data['offers_status'] = 0;
		}
		return $data;
	}
	public function skip_renew(Request $request)
	{
		$data = array();
		$post = new Subscribe_screen;
		$post->user_id = $request->user_id;

		$msg = $post->save();
		if ($msg) {
			$data['msg_en'] = $this->__transEn('skipped_successfully');
			$data['msg_ar'] = $this->__transAr('skipped_successfully');;
			$data['status'] = 1;
		} else {
			$data['msg_en'] = $this->__transEn('server_error');
			$data['msg_ar'] = $this->__transAr('server_error');
			$data['status'] = 0;
		}
		return $data;
	}


	public function salary_detail(Request $request)
	{
		$data = array();
		$salary_id = (string)DB::table('budgets')->where('user_id', $request->user_id)->where('budget_type', 1)->first()->id;
		$salary_amount = (string)DB::table('budgets')->where('user_id', $request->user_id)->where('budget_type', 1)->first()->budget_amount;
		$data['salary_detail'] =   DB::select(DB::raw("SELECT a.expense_type_id,b.expense_name,b.expense_name_ar,b.color,
	(SELECT COALESCE(SUM(net_total),0) FROM invoice_main WHERE expense_type = a.expense_type_id AND user_id = '$request->user_id' AND is_reset = 0) AS total_amount,
	(SELECT COALESCE(SUM(net_total),0) FROM invoice_main WHERE expense_type = a.expense_type_id AND user_id = '$request->user_id' AND is_reset = 0) * 100 / '$salary_amount' as percent 
	 FROM expenses a ,expense_types b WHERE b.id = a.expense_type_id 
	AND a.user_id = '$request->user_id' AND a.budget_id = '$salary_id' "));
		$data['salary_detail_status'] = 1;
		if (empty($data['salary_detail'])) {
			$data['salary_detail_status'] = 0;
			$data['msg_en'] = array('text' => 'Sorry salary expense not found', 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => 'Sorry salary expense not found ar', 'cls' => 'text-danger');
		}
		return $data;
	}

	//get budget detail

	public function budget_detail(Request $request)
	{
		$data = array();
		// for dating
		$fromToDate = "";
		if (!empty($request->from) && !empty($request->to)) {
			$is_reset = "";
			$fromToDate = " AND created_at BETWEEN $request->from AND $request->to";
		} else {
			$is_reset = " AND is_reset = 0";
			$fromToDate = "";
		}

		$data['budget_detail'] =  DB::select(DB::raw("SELECT a.expense_type_id,b.expense_name,b.expense_name_ar,b.color,
		(SELECT COALESCE(SUM(net_total),0) FROM invoice_main WHERE expense_type = a.expense_type_id AND user_id = '$request->user_id'$fromToDate$is_reset) AS total_amount,
		(SELECT COALESCE(SUM(net_total),0) FROM invoice_main WHERE expense_type = a.expense_type_id AND user_id = '$request->user_id'$fromToDate$is_reset) * 100 / '$request->budget_amount' as percent 
		FROM expenses a ,expense_types b WHERE b.id = a.expense_type_id 
		AND a.user_id = '$request->user_id' AND a.budget_id = '$request->budget_id' "));

		$data['budget_detail_status'] = 1;
		if (empty($data['budget_detail'])) {
			$data['budget_detail_status'] = 0;
			$data['msg_en'] = array('text' => 'Sorry budget expense not found', 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => 'Sorry budget expense not found ar', 'cls' => 'text-danger');
		}
		// expense type ids
		$array = Expenses::where('budget_id', $request->budget_id)->pluck('expense_type_id')->toArray();
		$array = implode(",", $array);
		$inAry = "";
		if (!empty($array)) {
			$inAry = " AND expense_type IN ($array)";
		} else {
			$inAry = " AND expense_type = 50000";
		}
		//return $array;
		$data['vendor_logo_url'] = "https://sarfapp.com/uploads/images/vendor/";
		//DB::enableQueryLog(); // Enable query log

		// for from and to dates
		if (!empty($array)) {
			$data['vendor_list'] =  DB::select(DB::raw("select a.id,a.uid,a.name,a.logo,(SELECT COALESCE(SUM(net_total),0) FROM invoice_main WHERE budget_id = '$request->budget_id' AND vendor_id = a.uid$fromToDate$is_reset) AS vendor_total, (SELECT COALESCE(count(id),0) FROM members WHERE vendor_id = a.uid AND user_id = '$request->user_id'$inAry) AS connect
		FROM vendor_detail a ORDER BY connect DESC"));
			//dd(DB::getQueryLog()); // Show results of log
			$data['vendor_list_status'] = 1;
		} else {
			$data['vendor_list']  = array();
		}
		if (empty($data['vendor_list'])) {
			$data['vendor_list_status'] = 0;
			$data['msg_en'] = $this->__transEn('member_list_not_found');
			$data['msg_ar'] = $this->__transAr('member_list_not_found');
		}
		return $data;
	}


	// simple invoice
	public function generate_custom_invoice(Request $request)
	{
		try {
			$data = array();
			if ($request->apptype == "app") {
				$id = $request->user_id;
			} else {
				$id = Auth::user()->id;
			}
			// generate custom invoice

			//$budget_id = DB::table('expenses')->where('user_id', $id)->where('expense_type_id', $request->expense_type)->first()->budget_id;


			$post = new Invoice_main;
			$post->user_id = ($id) ? $id : 0;
			$post->vendor_id = 0;
			$post->expense_type = $request->expense_type;
			$post->invoice_note = $request->invoice_note;
			$post->net_total = $request->net_total;
			$post->date = Date('Y-m-d');
			$post->created_at = Date('Y-m-d H:i:s');
			$post->status = 1;
			$post->budget_id = $request->budget_id;
			$post->is_approve = 1;
			$post->paid_status = 1;
			$post->invoice_type = 3; //is custom invoice
			$msg = $post->save();

			$inv_id = $post->id;
			// file att
			//$allowedfileExtension=['pdf','docx','jpg','png'];
			$files = $request->file('file_attach');
			if ($files) {	/*
				foreach ($files as $file) {   
					$extension = $file->getClientOriginalExtension();
					$check = in_array($extension,$allowedfileExtension);
					if($check) { */
				foreach ($request->file_attach as $mediaFiles) {

					$name = 'project/invoice_attachments/' . Str::random(30) . ".png";
					$mediaFiles->move(public_path('project/invoice_attachments/'), $name);
					//store image file into directory and 
					$attachData = [
						'invoice_main_id' => $inv_id,
						'file_attach' => $name,
					];
					Invoice_attachment::insert($attachData);
				}
				/*} else {
						$data['msg_en'] = $this->__transEn('invalid_file_format');
						$data['msg_ar'] = $this->__transAr('invalid_file_format');
						$data['inv_status'] = 0;
					}
				}*/
			}
			// file upload ends here
			if ($msg) {
				/*$post2 = new Alerts;
				$post2->user_id = ($id) ? $id : 0;
				$post2->vendor_id = 0;
				$post2->ref_id = $inv_id;
				$post2->title = "customer Invoice generated";
				$post2->discription = $request->invoice_note;
				$post2->alert_type = 1;
				$msg2 = $post2->save();*/
				$data['msg_en'] = array('text' => $this->__transEn('generated_successfully'), 'cls' => 'success');
				$data['msg_ar'] = array('text' => $this->__transAr('generated_successfully'), 'cls' => 'success');
				$data['inv_status'] = 1;
			} else {
				$data['inv_status'] = 0;
				$data['msg_en'] = array('text' => $this->__transEn('not_found'), 'cls' => 'text-danger');
				$data['msg_ar'] = array('text' => $this->__transAr('not_found'), 'cls' => 'text-danger');
			}
			return $data;
		} catch (\Throwable $th) {
			throw $th;
		}
	}

	//add shop to custom type list

	public function shop_add_type(Request $request)
	{
		$data = array();
		if (!isset(DB::table('members')->where('vendor_id', $request->vendor_id)->where('user_id', $request->user_id)->first()->id)) {
			$post1 = new Member;
			$post1->user_id = $request->user_id;
			$post1->vendor_id = $request->vendor_id;
			$post1->expense_type = $request->expense_type;
			$msg = $post1->save();
		} else {
			$msg = DB::table('members')->where('vendor_id', $request->vendor_id)->where('user_id', $request->user_id)->update(array('expense_type' => $request->expense_type));
		}
		if ($msg) {
			$data['status'] = 1;
		} else {
			$data['status'] = 0;
		}
		return $data;
	}

	public function read(Request $request)
	{
		$data = array();
		try {
			$data = [
				'alert_status' => '1',
			];
			$msg = Alerts::where('id', $request->id)->update($data);
			//return $this->sendResponse(true, '', $this->__transEn('alerts'), $this->__transAr('alerts'));
			if ($msg) {
				$data['status'] = 1;
			} else {
				$data['status'] = 0;
			}
		} catch (\Throwable $th) {
			throw $th;
		}
		return $data;
	}

	// near by
	public function near_by(Request $request)
	{
		$data = array();
		try {
			$data['data'] = $this->nearByInLocation($request->expense_type, $request->lat, $request->lng);
			$data['status'] = 1;
			if (empty($data['data'])) {
				$data['status'] = 0;
				$data['msg_en'] = $this->__transEn('record_not_found');
				$data['msg_ar'] = $this->__transAr('record_not_found');
			}
			return $data;
		} catch (\Throwable $th) {
			throw $th;
		}
	}


	public function offer_read(Request $request)
	{
		$data = array();
		try {
			$data = [
				'read_status' => '1',
			];
			$msg = Offer_users::where('id', $request->id)->update($data);
			//return $this->sendResponse(true, '', $this->__transEn('alerts'), $this->__transAr('alerts'));
			if ($msg) {
				$data['status'] = 1;
			} else {
				$data['status'] = 0;
			}
		} catch (\Throwable $th) {
			throw $th;
		}
		return $data;
	}

	public function vendor_online(Request $request)
	{
		$data = array();

		$data['vendor_logo_url'] = "https://sarfapp.com/uploads/images/vendor/";
		$data['vendors'] =   DB::select(DB::raw("SELECT * FROM vendor_detail a WHERE NOT EXISTS
        (
        SELECT  vendor_id 
        FROM    members b
        WHERE   b.vendor_id = a.uid AND user_id = '$request->user_id'
        ) AND a.vendor_status = 1 AND business_type != 0 "));
		$data['vendors_status'] = 1;
		if (empty($data['vendors'])) {
			$data['vendors_status'] = 0;
			$data['msg_en'] = 'Sorry vendors not found';
			$data['msg_ar'] = 'Sorry vendors not found';
		}
		return $data;
	}


	public function otp_delete(Request $request)
	{
		$data = array();
		try {
			$data1 = [
				'otp_delete' => 1234,
			];
			$msg = User::where('id', $request->user_id)->update($data1);

			if ($msg) {
				$data['status'] = 1;
				$data['msg_en'] = $this->__transEn('otp send successfully');
				$data['msg_ar'] = $this->__transAr('otp send successfully ar');
			} else {
				$data['status'] = 0;
				$data['msg_en'] = $this->__transEn('otp send error');
				$data['msg_ar'] = $this->__transAr('otp send error ar');
			}
		} catch (\Throwable $th) {
			throw $th;
		}
		return $data;
	}

	public function delete_account(Request $request)
	{
		$data = array();

		$otp = strip_tags($request->otp);

		if (User::where('otp_delete', $otp)->where('id', $request->user_id)->exists()) {
			try {
				$data = [
					'status' => '5',
				];
				$msg = User::where('id', $request->user_id)->update($data);

				if ($msg) {
					$data['status'] = 1;
					$data['msg_en'] = $this->__transEn('account_deleted success fully');
					$data['msg_ar'] = $this->__transAr('account_deleted success fully ar');
				} else {
					$data['status'] = 0;
					$data['msg_en'] = $this->__transEn('Sorry Account not deleted');
					$data['msg_ar'] = $this->__transAr('Sorry Account not deleted ar');
				}
			} catch (\Throwable $th) {
				throw $th;
			}
		} else {
			$data['status'] = 0;
			$data['msg_en'] = $this->__transEn('Sorry otp incorrect');
			$data['msg_ar'] = $this->__transAr('Sorry otp incorrectar');
		}


		return $data;
	}
}
