<?php
namespace App\Http\Controllers;
use App\Models\Contact_us;
use App\Models\Setting;
use App\Models\Back_images;
use App\Models\Banners;
use App\Models\Contacts;
use App\Models\ExLinks;
use App\Models\Features;
use App\Models\Home_sections;
use App\Models\Socials;
use App\Models\Package;
use App\Models\Subscription;
use App\Models\Partners;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Session;

class FrontController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {   
	    $data = array();
	    // get data from database
	    $data['banner_content'] = Banners::all();
	    $data['white_logo'] = Setting::first()->white_logo;
	    $data['dark_logo'] = Setting::first()->dark_logo;
	    
	    $data['btn_started'] = ExLinks::where('btn_name', 'started')->get();
	    $data['btn_download_app'] = ExLinks::where('btn_name', 'download_app')->get();

	    $data['features'] = Features::where('status', 1)->get();
	    $data['sections'] = Home_sections::where('status', 1)->where('is_image', 0)->get();
	    $data['sections_download'] = Home_sections::where('status', 1)->where('is_image', 1)->get();

	    $data['btn_descover'] = ExLinks::where('btn_name', 'discover')->get();
	    $data['btn_descover2'] = ExLinks::where('btn_name', 'discover2')->get();
	    $data['play_store'] = ExLinks::where('btn_name', 'play_store')->get();
	    $data['app_store'] = ExLinks::where('btn_name', 'app_store')->get();

	    $data['contacts'] = Contacts::where('status', 1)->orderby('orderby')->get();
	    $data['socials'] = Socials::where('status', 1)->orderby('orderby')->get();
	    $data['copyright'] = Setting::first()->copyright;
	    // background image
	    $data['header_shape'] = Back_images::where('type','top')->first()->image;
	    $data['footer_shape'] = Back_images::where('type','footer')->first()->image;

	    $data['partners'] = Partners::where('status', 1)->orderby('order_by')->get();

	    $data['language'] = Session::get('language');
	    return $data;
    }

	//contact msgs 
	public function contact_msg(Request $request){
		$data = array();
		/*$request->validate([
            'name' => ['required'],
            'message' => ['required']
        ]);*/
        if (empty($request->name)) {
        	$data['msg_en'] = array('text' => 'Name is required', 'cls' => 'error');
        	$data['msg_ar'] = array('text' => 'Name is required AR', 'cls' => 'error');
        }elseif (empty($request->message)) {
        	$data['msg_en'] = array('text' => 'Message is required', 'cls' => 'error');
        	$data['msg_ar'] = array('text' => 'Message is required AR', 'cls' => 'error');
        }else{
			$post = new Contact_us;
		  	$post->name = $request->name;
		  	$post->email = $request->email;
		  	$post->msg = $request->message;
		  	$msg = $post->save();
			if ($msg) {
				$data['msg_en'] = array('text' => 'Send successfully', 'cls' => 'success');
				$data['msg_ar'] = array('text' => 'Send successfully AR', 'cls' => 'success');
				$data['status'] = 1;
	        } else {
				$data['msg_en'] = array('text' => 'Not Send', 'cls' => 'error');
				$data['msg_ar'] = array('text' => 'Not Send AR', 'cls' => 'error');
				$data['status'] = 0;
	        }
	    }
	 	return $data; 
	}	
}

