<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\Project\Budget;
use App\Models\Admin\User;
use App\Models\Project\UserDetail;
use App\Models\Project\Vendor;
use App\Models\Project\Member;
use App\Models\Project\Invoice_main;
use App\Models\Project\Expense_type;
use App\Models\Project\Expenses;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Traits\ApiLanguageTrait;

class ExpenseController extends Controller
{
	use ApiLanguageTrait;
	/**
	 * Display a listing of the resource.
	 *
	 * @return \Illuminate\Http\Response
	 */
	public function user_exptype_list(Request $request)
	{
		if ($request->type == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		$msg = 0;
		$data['user_exptype_list'] = DB::select(DB::raw("SELECT a.id,a.expense_name,a.color,a.budget_id,(SELECT budget_name FROM budgets WHERE id = a.budget_id) AS budget_name FROM expense_types a WHERE a.type = 2 AND a.user_id = '$id' AND a.status = 1"));

		if (empty($data['user_exptype_list'])) {
			$data['user_exptype_list_status'] = 0;
			$data['msg_en'] = $this->__transEn('user_expense_list_not_found');
			$data['msg_ar'] = $this->__transAr('user_expense_list_not_found');
		} else {
			$data['user_exptype_list_status'] = 1;
		}


		$data['budget_list'] =  Budget::query()
			->select('id', 'budget_name')->where('user_id', $request->user_id)->get();
		$data['budget_list_status'] = 1;
		$data['colors_list'] =  DB::select(DB::raw("SELECT id,c_code FROM colors WHERE status = 1 "));
		$data['colors_list_status'] = 1;
		if (empty($data['budget_list'])) {
			$data['budget_list_status'] = 0;
			$data['msg_en'] = array('text' => $this->__transEn('budget_list_not_found'), 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => $this->__transAr('budget_list_not_found'), 'cls' => 'text-danger');
		}
		if (empty($data['colors_list'])) {
			$data['colors_list_status'] = 0;
			$data['msg_en'] = array('text' => 'Sorry color list not found', 'cls' => 'text-danger');
			$data['msg_ar'] = array('text' => 'Sorry color list not found ar', 'cls' => 'text-danger');
		}
		return $data;
	}


	public function data(Request $request)
	{
		$id = $request->id;
		$data = array();
		$data['expense_type'] = DB::table('expense_types')
			->join('expenses', 'expense_types.id', '=', 'expenses.expense_type_id')
			->select('expense_types.*', 'expenses.amount')->where('expense_types.id', $id)
			->get();
		$invoice = Invoice_main::where('expense_type', $id)->get();
		$data['invoices'] = $invoice->count();
		$member = Member::where('exp_type_id', $id)->get();
		$data['members'] = $member->count();
		return $data;
	}

	//add expense type 
	public function expense_type_add(Request $request)
	{
		if ($request->apptype == "app") {
			$id = $request->user_id;
		} else {
			$id = Auth::user()->id;
		}
		$data = array();
		if (empty($request->expense_name)) {
			$data['msg_en'] = array('text' => $this->__transEn('enter_expense_name'), 'cls' => 'warning');
			$data['msg_ar'] = array('text' => $this->__transAr('enter_expense_name'), 'cls' => 'warning');
			$data['status'] = 0;
		} else if (empty($request->expense_budget)) {
			$data['msg_en'] = array('text' => $this->__transEn('connect_to_any_budget'), 'cls' => 'warning');
			$data['msg_ar'] = array('text' => $this->__transAr('connect_to_any_budget'), 'cls' => 'warning');
			$data['status'] = 0;
		} else if (Expense_type::where(['expense_name'=>$request->expense_name, 'type'=>'2', 'user_id'=>$id, 'budget_id'=>$request->expense_budget])->where('status', '!=',0)->exists()) {
			$data['msg_en'] = array('text' => $this->__transEn('name_already_exist'), 'cls' => 'warning');
			$data['msg_ar'] = array('text' => $this->__transAr('name_already_exist'), 'cls' => 'warning');
			$data['status'] = 0;
		}
		// else if (Expense_type::where('color', $request->expense_color)->where('user_id', $request->user_id)->exists()) {
		// 	$data['msg_en'] = array('text' => 'Color  ALready Exist', 'cls' => 'warning');
		// 	$data['msg_ar'] = array('text' => 'Color ALready Exist ar', 'cls' => 'warning');
		// 		$data['status'] = 0;
		// } 
		else {
			$post = new Expense_type;
			$post->expense_name = $request->expense_name;
			$post->expense_name_ar = strip_tags($request->expense_name);
			$post->color = $request->expense_color;
			$post->budget_id = $request->expense_budget;
			$post->type = "2";
			$post->user_id = $id;
			$msg = $post->save();
			if ($msg) {
				//$data['expense_user'] =   DB::select(DB::raw("SELECT expense_types_users.*, expenses.amount FROM `expense_types_users` LEFT JOIN `expenses` ON expense_types_users.id = expenses.expense_type_user_id"));
				$data['msg_en'] = array('text' => $this->__transEn('saved_successfully'), 'cls' => 'success');
				$data['msg_ar'] = array('text' => $this->__transAr('saved_successfully'), 'cls' => 'success');
				$data['status'] = 1;
				$post2 = new Expenses;
				$post2->expense_type_id = $post->id;
				$post2->user_id = $post->user_id;
				$post2->budget_id = $post->budget_id;
				$msg = $post2->save();
			} else {
				$data['msg_en'] = array('text' => $this->__transEn('not_saved'), 'cls' => 'error');
				$data['msg_ar'] = array('text' => $this->__transAr('not_saved'), 'cls' => 'error');
				$data['status'] = 0;
			}
		}
		return $data;
	}

	//update profile info
	public function exptype_update(Request $request)
	{
		$data = array();


		$post = Expense_type::find($request->id);
		$post->expense_name = strip_tags($request->expense_name);
		$post->expense_name_ar = strip_tags($request->expense_name);
		$post->color = $request->color;
		$post->budget_id = $request->budget_id;
		$msg = $post->save();
		if ($msg) {

			DB::table('expenses')
				->where('expense_type_id', $request->id)
				->where('user_id', $request->user_id)
				->update(array('budget_id' => $request->budget_id));
			$data['msg_en'] = array('text' => $this->__transEn('update_success'), 'cls' => 'success');
			$data['msg_ar'] = array('text' => $this->__transAr('update_success'), 'cls' => 'success');
			$data['status'] = 1;
		} else {
			$data['msg_en'] = array('text' => $this->__transEn('update_fail'), 'cls' => 'error');
			$data['msg_ar'] = array('text' => $this->__transAr('update_fail'), 'cls' => 'error');
			$data['status'] = 0;
		}

		return $data;
	}

	//update profile info
	public function update(Request $request)
	{
		$data = array();
		$request->validate([
			'expense_name' => ['required'],
			'budget_id' => ['required'],
			'color' => ['required']
		]);
		if (empty($request->expense_name)) {
			$data['msg_en'] = array('text' => $this->__transEn('enter_expense_name'), 'cls' => 'warning');
			$data['msg_ar'] = array('text' => $this->__transAr('enter_expense_name'), 'cls' => 'warning');
		} elseif (empty($request->budget_id)) {
			$data['msg_en'] = array('text' => $this->__transEn('connect_to_any_budget'), 'cls' => 'warning');
			$data['msg_ar'] = array('text' => $this->__transAr('connect_to_any_budget'), 'cls' => 'warning');
		} elseif (empty($request->color)) {
			$data['msg_en'] = array('text' => $this->__transEn('choose'), 'cls' => 'warning');
			$data['msg_ar'] = array('text' => $this->__transAr('choose'), 'cls' => 'warning');
		} else {
			$post = Expense_types_user::find($request->id);
			$post->expense_name = strip_tags($request->expense_name);
			$post->expense_name_ar = strip_tags($request->expense_name);
			$post->color = $request->color;
			$post->budget_id = $request->budget_id;
			$msg = $post->save();
			if ($msg) {
				$data['msg_en'] = array('text' => $this->__transEn('update_success'), 'cls' => 'success');
				$data['msg_ar'] = array('text' => $this->__transAr('update_success'), 'cls' => 'success');
				$data['status'] = 1;
			} else {
				$data['msg_en'] = array('text' => $this->__transEn('update_fail'), 'cls' => 'error');
				$data['msg_ar'] = array('text' => $this->__transAr('update_fail'), 'cls' => 'error');
				$data['status'] = 0;
			}
		}
		return $data;
	}

	//destroy info
	public function destroy($id)
	{
		$data = array();
		$msg = Expense_types_user::find($id)->delete();
		if ($msg) {
			$data['msg_en'] = array('text' => $this->__transEn('delete_success'), 'cls' => 'success');
			$data['msg_ar'] = array('text' => $this->__transAr('delete_success'), 'cls' => 'success');
			$data['status'] = 1;
		} else {
			$data['msg_en'] = array('text' => $this->__transEn('delete_fail'), 'cls' => 'error');
			$data['msg_ar'] = array('text' => $this->__transAr('delete_fail'), 'cls' => 'error');
			$data['status'] = 0;
		}
		return $data;
	}

	public function exptype_delete(Request $request)
	{
		$data = array();
		$id = $request->exptype_id;
		$msg = DB::table('expense_types')->where('id', $request->exptype_id)->update(array('status' => 0));
		//	$msg = '';
		if ($msg) {
			$data['msg_en'] = array('text' => $this->__transEn('delete_success'), 'cls' => 'success');
			$data['msg_ar'] = array('text' => $this->__transAr('delete_success'), 'cls' => 'success');
			$data['status'] = 1;
		} else {
			$data['msg_en'] = array('text' => $this->__transEn('delete_fail'), 'cls' => 'error');
			$data['msg_ar'] = array('text' => $this->__transAr('delete_fail'), 'cls' => 'error');
			$data['status'] = 0;
		}
		return $data;
	}
}
