<?php

namespace App\Http\Controllers\api;

use App\Http\Controllers\Controller;
use App\Models\Project\Budget;
use App\Models\Admin\User;
use App\Models\Project\UserDetail;
use App\Models\Project\Vendor;
use App\Models\Project\Member;
use App\Models\Project\Expense_type;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Traits\ApiLanguageTrait;

class BudgetController extends Controller
{
	use ApiLanguageTrait;

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function budget_list(Request $request)
    {
    	if($request->type == "app"){ $id = $request->user_id; } else{ $id = Auth::user()->id; }
	    $data = array();
		$msg = 0;
	 	$budget_list = Budget::query()->select('id', 'budget_name','budget_amount','dated')->where('user_id',$id)->where('budget_type', 2)->where('budget_status', 1)->get();
		foreach ($budget_list as $key => $bud) {
			$data['budget_list'][] = $bud;
			$bud_id = $bud->id;

			$data['budget_list'][$key]['type_main'] = DB::select(DB::raw("SELECT expense_types.id,expense_types.expense_name,expense_types.color,(SELECT COALESCE(count(id),0) FROM expenses WHERE expense_type_id = expense_types.id AND user_id = '$id' AND budget_id = '$bud_id') AS exist,(SELECT COALESCE(count(id),0) FROM expenses WHERE expense_type_id = expense_types.id AND user_id = '$id' AND budget_id != '$bud_id') AS connect_other FROM `expense_types` WHERE type = 1"));
			$data['budget_list'][$key]['type_custom'] = DB::select(DB::raw("SELECT expense_types.id,expense_types.expense_name,expense_types.color,(SELECT COALESCE(count(id),0) FROM expenses WHERE expense_type_id = expense_types.id AND user_id = '$id' AND budget_id = '$bud_id') AS exist,(SELECT COALESCE(count(id),0) FROM expenses WHERE expense_type_id = expense_types.id AND user_id = '$id' AND budget_id != '$bud_id') AS connect_other FROM `expense_types` WHERE type != 1 AND user_id = '$id'"));

		}

		if(empty($data['budget_list'])){
			$data['budget_list_status'] = 0;
			$data['msg_en'] = $this->__transEn('budget_not_found');
			$data['msg_ar'] = $this->__transAr('budget_not_found');
		}else{
			$data['budget_list_status'] = 1;
		}
        return $data;
    }

//update budget
	public function budget_update(Request $request){
		$data = array();
		if($request->apptype == "app"){ $id = $request->user_id; } else{ $id = Auth::user()->id; }
	    if (Budget::where('budget_name', $request->budget_name)->where('user_id',$request->user_id)->where('id','!=',$request->budget_id)->where('budget_status', 1)->exists()) {
       		$data['msg_en'] = array('text' => $this->__transEn('name_already_exist'), 'cls' => 'warning');
       		$data['msg_ar'] = array('text' => $this->__transAr('name_already_exist'), 'cls' => 'warning');
      	}
	  	else {
			$post = Budget::find($request->budget_id);
		  	$post->budget_name = $request->budget_name;
		  	$post->budget_amount = $request->budget_amount;
		  	$msg = $post->save();

			// $ids = explode (",", $request->expense_type_array);
			// DB::table('expense_types')->where('budget_id', $post->id)->where('user_id', $request->user_id)->update(array('budget_id' => 0));

			// DB::table('expenses')->where('budget_id', $post->id)->where('user_id', $request->user_id)->update(array('budget_id' => 0));

			// foreach ($ids as $val) {


			// 	DB::table('expense_types')->where('id', intval($val))->where('user_id', $request->user_id)->update(array('budget_id' => $post->id));


			// 	DB::table('expenses')->where('expense_type_id', intval($val))->where('user_id', $request->user_id)->update(array('budget_id' => $post->id));
			// }

			if ($msg) {
				$data['msg_en'] = array('text' => $this->__transEn('update_success'), 'cls' => 'success');
				$data['msg_ar'] = array('text' => $this->__transAr('update_success'), 'cls' => 'success');
				$data['status'] = 1;
	        } else {
				$data['msg_en'] = array('text' => $this->__transEn('server_error'), 'cls' => 'danger');
				$data['msg_ar'] = array('text' => $this->__transAr('server_error'), 'cls' => 'danger');
				$data['status'] = 0;
	        }
		}
	 	return $data;
	}

    /*public function budget_edit(Request $request)
    {

	    $data = array();
		$data['budgets'] = DB::select(DB::raw("SELECT id,budget_name FROM budgets WHERE user_id = '$request->user_id' ORDER BY budget_type ASC "));
		//Budget::where('user_id', $id)->where('budget_type', 1)->get();
        return $data;
    }*/

	//add budget type
	public function add(Request $request){
		$data = array();
		if($request->apptype == "app"){ $id = $request->user_id; } else{ $id = Auth::user()->id; }
	    if(empty($request->budget_name) || empty($request->budget_amount)) {
			$data['msg_en'] = array('text' => $this->__transEn('empty_fields_not_allowed'), 'cls' => 'warning');
			$data['msg_ar'] = array('text' => $this->__transAr('empty_fields_not_allowed'), 'cls' => 'warning');
			$data['status'] = 0;
		}
		else if (Budget::where('budget_name', $request->budget_name)->where('user_id',$request->user_id)->where('budget_status', 1)->exists()) {
       		$data['msg_en'] = array('text' => $this->__transEn('name_already_exist'), 'cls' => 'warning');
       		$data['msg_ar'] = array('text' => $this->__transAr('name_already_exist'), 'cls' => 'warning');
			$data['status'] = 0;
      	}
	  	else {
			$projectNumber = Budget::where('user_id', $id)->latest()->first();
			$post = new Budget;
		  	$post->budget_name = $request->budget_name;
		  	$post->budget_amount = $request->budget_amount;
		  	$post->project_number = ($projectNumber == null) ? "#1": "#".(intval(str_replace("#", "", $projectNumber->project_number)) + 1);
		  	$post->budget_type = 2;
		  	$post->dated = DATE('Y-m-d');
		  	$post->user_id = $id;
		  	$msg = $post->save();
			// $ids = explode (",", $request->expense_type_array);
			// foreach ($ids as $val) {
			// 	DB::table('expense_types')->where('id', intval($val))->where('user_id', $request->user_id)->update(array('budget_id' => $post->id));
			// 	DB::table('expenses')->where('expense_type_id', intval($val))->where('user_id', $request->user_id)->update(array('budget_id' => $post->id));
			// }

			if ($msg) {
				$data['msg_en'] = array('text' => $this->__transEn('saved_successfully'), 'cls' => 'success');
				$data['msg_ar'] = array('text' => $this->__transAr('saved_successfully'), 'cls' => 'success');
				$data['status'] = 1;
	        } else {
				$data['msg_en'] = array('text' => $this->__transEn('server_error'), 'cls' => 'danger');
				$data['msg_ar'] = array('text' => $this->__transAr('server_error'), 'cls' => 'danger');
				$data['status'] = 0;
	        }
		}
	 	return $data;
	}


	//update profile info


	//update salary info
	/*public function updateSalary($id, Request $request){
		$data = array();

        if(empty($request->budget_amount)) {
			$data['msg_en'] = array('text' => 'Enter budget amount', 'cls' => 'warning');
			$data['msg_ar'] = array('text' => 'Enter budget amount', 'cls' => 'warning');
		}
		elseif(empty($request->dated)){
			$data['msg_en'] = array('text' => 'Enter date', 'cls' => 'warning');
			$data['msg_ar'] = array('text' => 'Enter date', 'cls' => 'warning');
		}
		else{
		  	$post = Budget::find($id);
		  	$post->budget_amount = intval($request->budget_amount);
		  	$post->dated = $request->dated;
		  	$post->expense_type = $request->expense_type;
		  	$post->expense_type_user = $request->expense_type_user;
		  	$msg = $post->save();
		  	if ($msg) {
				$data['budgets_salary'] = DB::table('budgets')
					->join('expense_types', 'budgets.expense_type', '=', 'expense_types.id')
					->select('budgets.*', 'expense_types.expense_name')->where('budgets.user_id',$id)->where('budgets.budget_type', 1)
					->get();
				$data['msg'] = array('text' => 'Updated successfully', 'cls' => 'success');
				$data['msg'] = array('text' => 'Updated successfully', 'cls' => 'success');
				$data['status'] = 1;
		  	}else{
		  		$data['msg'] = array('text' => 'Updation Fail', 'cls' => 'error');
		  		$data['msg'] = array('text' => 'Updation Fail', 'cls' => 'error');
		  		$data['status'] = 0;
		  	}
		}
	  	return $data;
	}
*/
	//destroy info
	public function destroy($id){
		$data = array();
	  	$msg = Budget::find($id)->delete();
	  	if ($msg) {
			$data['msg_en'] = array('text' => $this->__transEn('delete_success'), 'cls' => 'success');
			$data['msg_ar'] = array('text' => $this->__transAr('delete_success'), 'cls' => 'success');
			$data['status'] = 1;
	  	}else{
	  		$data['msg_en'] = array('text' => $this->__transEn('delete_fail'), 'cls' => 'error');
	  		$data['msg_ar'] = array('text' => $this->__transAr('delete_fail'), 'cls' => 'error');
	  		$data['status'] = 0;
	  	}
	  	return $data;
	}
	
	public function budget_reset(Request $request){
				$id = $request->budget_id;
				$data = array();
		
			//$msg = DB::table('expenses')->where('budget_id', $id)->where('user_id', $request->user_id)->update(array('amount' => 0));
			$msg = DB::table('invoice_main')->where('budget_id', $id)->update(array('is_reset' => 1));

			if ($msg) {
				$data['msg_en'] = array('text' => $this->__transEn('reset_success'), 'cls' => 'success');
				$data['msg_ar'] = array('text' => $this->__transAr('reset_success'), 'cls' => 'success');
				$data['status'] = 1;
	        } else {
				$data['msg_en'] = array('text' => $this->__transEn('not_reset'), 'cls' => 'error');
				$data['msg_ar'] = array('text' => $this->__transAr('not_reset'), 'cls' => 'error');
				$data['status'] = 0;
	        }	 
		
	 	return $data; 
	}

	
	public function budget_delete(Request $request){
		$id = $request->budget_id;
		$data = array();

	$msg = DB::table('budgets')->where('id', $request->budget_id)->update(array('budget_status' => 0));
	//$msg = DB::table('invoice_main')->where('budget_id', $id)->update(array('is_reset' => 1));
	//	$msg = '';
	if ($msg) {
		$data['msg_en'] = array('text' => $this->__transEn('delete_success'), 'cls' => 'success');
		$data['msg_ar'] = array('text' => $this->__transAr('delete_success'), 'cls' => 'success');
		$data['status'] = 1;
	} else {
		$data['msg_en'] = array('text' => $this->__transEn('not_delete'), 'cls' => 'error');
		$data['msg_ar'] = array('text' => $this->__transAr('not_delete'), 'cls' => 'error');
		$data['status'] = 0;
	}	 

 return $data; 
}
	
}
