<?php
       
namespace App\Http\Controllers\Project;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;      
use Illuminate\Support\Facades\DB;      
use App\Models\Admin\User;
use Illuminate\Http\Request;
use Response;
use DataTables;
       
class UserController extends Controller
{
   
	public function __construct()
    {
        $this->middleware('auth');
    }
    public function index(Request $request)
    {   
        if ($request->ajax()) {
            $data = User::all()->where("status",">",0)->where('user_type','1')->sortByDesc("id");
            return Datatables::of($data)
            ->addIndexColumn()
            ->setRowId(function ($row) { return $row->id; })
            ->addColumn('status', function($row){
              $checked = "";
              if ( $row->status == 1) { $checked = "checked"; }
              $swtich = '
                <label class="switch" for="checkbox'.$row->id.'">
                    <input class="state_switch" type="checkbox" id="checkbox'.$row->id.'" value="'.$row->id.'" '.$checked.' />
                    <div class="slider round"></div>
                </label>
              ';
              return $swtich;
            })
            ->addColumn('action', function($row){
                $btn = '
                    <a href="'.url("/user_list/user_detail/".$row->id).'" type="button" class="btn btn-outline-warning btn-sm">'.trans("admin.detail").'</a>

                    <!--<a type="button" class="btn btn-outline-secondary btn-xs" onClick="edit_user('.$row->id.');"><i class="bi-pencil-square" style="font-size:16;line-height:0;"></i></a>

                    <a type="button" class="btn btn-outline-danger btn-xs" onClick="delete_user('.$row->id.');"><i class="bi-trash-fill" style="font-size:16;line-height:0;"></i></a>-->
                ';
                return $btn;
            })
            ->rawColumns(['status', 'action'])
            ->make(true);
        }
        return view('sarf.users.manage_users'); 
    }

    public function addModel(){
        return view('sarf.users.user_add');
    }

    public function save(Request $request){
        if (checkAccess('r_add')) {
            if (User::where('email', $request->u_email)->exists()) {
              echo  json_encode(array('text'=>'Email already exists','cls'=>'warn'));
            } else{
                $post = new User;
                $post->name = $request->u_name;
                //$post->name_ar = $request->u_name_ar;
                /*$post->email = $request->u_email;*/
                $post->username = $request->username;
                $post->role = $request->u_role;
                $post->password = Hash::make($request->u_password);
                $msg = $post->save();
                if ($msg) {
                  echo  json_encode(array('text'=>'saved successfully','cls'=>'success'));
                } else {
                  echo  json_encode(array('text'=>'Not Saved','cls'=>'error'));
                }
            }
        } else{
          echo  json_encode(array('text' => 'You have no permission', 'cls' => 'error'));
        }
    }

    function editModel(Request $request){
        $user = User::find($request->id);
        return view('admin.users.user_edit',compact('user'));
    }

    function update(Request $request){
        if (checkAccess('r_edit')) {
            $post = User::find($request->id);
            $post->name = $request->u_name;
            //$post->name_ar = $request->u_name_ar;
            /*$post->email = $request->u_email;*/
            $post->username = $request->username;
            $post->role = $request->u_role;
            if($request->u_password){
                $post->password = Hash::make($request->u_password);
            }
            $msg = $post->save();
            if ($msg) {
                echo  json_encode(array('text'=>'updated successfully','cls'=>'success'));
            } else {
                echo  json_encode(array('text'=>'not saved','cls'=>'error'));
            }
        } else{
          echo  json_encode(array('text' => 'You have no permission', 'cls' => 'error'));
        }
    }

    function status(Request $request)
    {
        $state = getAny("status", "users", "id", $request->id);
        if ($state == 1) {
            $update_state = 2;
        }else{
            $update_state = 1;
        }
        $post = User::find($request->id);
        $post->status = $update_state;
        $msg = $post->save();
        if ($msg) {
          echo  json_encode(array('text' => 'Status Changed', 'cls' => 'success'));
        } else {
          echo  json_encode(array('text' => 'Error', 'cls' => 'error'));
        }
    }

    function destroy(Request $request){
        if (checkAccess('r_delete')) {
            $msg = User::where('id',$request->id)->delete();
            if ($msg) {
                echo  json_encode(array('text'=>'Delete successfully','cls'=>'success'));
            } else {
                echo  json_encode(array('text'=>'not deleted','cls'=>'error'));
            }
        } else{
          echo  json_encode(array('text' => 'You have no permission', 'cls' => 'error'));
        }
    }

    function user_detail($id){
        $data=array();
        $data['post'] = DB::table('users')
                    ->join('user_detail', 'users.id', '=', 'user_detail.uid')
                    ->select('user_detail.name', 'user_detail.gender', 'users.id', 'users.username')
                    ->where('users.id',$id)
                    ->get();
        $data['invoices'] = DB::table('invoice_main')->where('user_id', $id)->limit(6)->get();
        $data['subscription'] = DB::table('subscription')->where('user_id', $id)->limit(6)->get();

        $data['invoices_count'] = DB::table('invoice_main')->where('user_id', $id)->count();
        $data['subscription_count'] = DB::table('subscription')->where('user_id', $id)->count();
        return view('sarf.users.detail', compact('data'));
    }
    /*user end*/

    // business start
    public function business_list(Request $request)
    {   
        if ($request->ajax()) {
            $data = User::all()->where("status",">",0)->where('user_type','2')->sortByDesc("id");
            return Datatables::of($data)
            ->addIndexColumn()
            ->setRowId(function ($row) { return $row->id; })
            ->addColumn('status', function($row){
              $checked = "";
              if ( $row->status == 1) { $checked = "checked"; }
              $swtich = '
                <label class="switch" for="checkbox'.$row->id.'">
                    <input class="state_switch" type="checkbox" id="checkbox'.$row->id.'" value="'.$row->id.'" '.$checked.' />
                    <div class="slider round"></div>
                </label>
              ';
              return $swtich;
            })
            ->addColumn('action', function($row){
                $btn = '
                    <a href="'.url("/business_list/vendor_detail/".$row->id).'" type="button" class="btn btn-outline-warning btn-sm">'.trans("admin.detail").'</a>

                    <!--<a type="button" class="btn btn-outline-secondary btn-xs" onClick="edit_user('.$row->id.');"><i class="bi-pencil-square" style="font-size:16;line-height:0;"></i></a>

                    <a type="button" class="btn btn-outline-danger btn-xs" onClick="delete_user('.$row->id.');"><i class="bi-trash-fill" style="font-size:16;line-height:0;"></i></a>-->
                ';
                return $btn;
            })
            ->rawColumns(['status','action'])
            ->make(true);
        }
        return view('sarf.business.business'); 
    }

    function statusBusiness(Request $request)
    {
        $state = getAny("status", "users", "id", $request->id);
        if ($state == 1) {
            $update_state = 2;
        }else{
            $update_state = 1;
        }
        $post = User::find($request->id);
        $post->status = $update_state;
        $msg = $post->save();
        if ($msg) {
          echo  json_encode(array('text' => 'Status Changed', 'cls' => 'success'));
        } else {
          echo  json_encode(array('text' => 'Error', 'cls' => 'error'));
        }
    }

    function vendor_detail($id){
        $data=array();
        $data['post'] = DB::table('users')
                    ->join('vendor_detail', 'users.id', '=', 'vendor_detail.uid')
                    ->select('vendor_detail.*', 'users.id', 'users.username')
                    ->where('users.id',$id)
                    ->get();
        $data['invoices'] = DB::table('invoice_main')->where('vendor_id', $id)->limit(6)->get();
        $data['subscription'] = DB::table('subscription')->where('user_id', $id)->limit(6)->get();

        $data['invoices_count'] = DB::table('invoice_main')->where('vendor_id', $id)->count();
        $data['subscription_count'] = DB::table('subscription')->where('user_id', $id)->count();
        return view('sarf.business.detail', compact('data'));
    }
    // business end
}