<?php

namespace App\Http\Controllers\Project;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Project\Subscription;
use Response;
use Validator;
use DataTables;

class SubsController extends Controller
{
    public function index(Request $request)
  {
    //$post = Subscription::all()->where("status",">",0)->sortByDesc("id");
    if ($request->ajax()) {
      $data = Subscription::all()->where("status",">",0)->sortByDesc("id");
      return Datatables::of($data)
      ->addIndexColumn()
      ->setRowId(function ($row) { return $row->id; })
      ->addColumn('user', function($row){
          return getAny('name','users','id',$row->user_id);
      })
      ->addColumn('pkg', function($row){
          return pkgName($row->pkg_id);
      })
      ->addColumn('status', function($row){
          $checked = "";
          if ( $row->status == 1) { $checked = "checked"; }
          $swtich = '
            <label class="switch" for="checkbox'.$row->id.'">
                <input class="state_switch" type="checkbox" id="checkbox'.$row->id.'" value="'.$row->id.'" '.$checked.' />
                <div class="slider round"></div>
            </label>
          ';
          return $swtich;
      })
      ->addColumn('action', function($row){
          $btn = '
            <button onclick="edit_subs('.$row->id.');" id="edit_sub_cat" class="btn btn-warning btn-xs">Edit</button>
            <button class="btn btn-xs btn-danger btn-delete" value="'.$row->id.'">Delete</button>
          ';
          return $btn;
      })
      ->rawColumns(['action','status'])
      ->make(true);
    }
    return view('sarf/subscription.subscription');
  }

  public function add()
  {
    //$Subscription = Subscription::where('cat_status',1)->get();
    return view('sarf/Subscription.add');
  }

  public function save(Request $request)
  {
    $new_name = "";
    if (Subscription::where('name', $request->name)->exists()) {
        echo  json_encode(array('text' => 'already exists', 'cls' => 'error'));
    } else {
        $post = new Subscription;
        $post->name = $request->name;
        $post->duration = $request->date;
        $post->amount = $request->amount;
        $msg = $post->save();
        if ($msg) {
            echo json_encode(array('text' => 'Saved successfully', 'cls' => 'success'));
        } else {
            echo json_encode(array('text' => 'not saved', 'cls' => 'error'));
        }
    }
  }

  function edit(Request $request)
  {
    $post = Subscription::find($request->id);
    return view('sarf/subscription.edit', compact('post'));
  }

  function update(Request $request)
  {
    $post = Subscription::find($request->id);
    $post->name = $request->name;
    $post->duration = $request->date;
    $post->amount = $request->amount;
    $msg = $post->save();
    if ($msg) {
      echo  json_encode(array('text' => 'Updated successfully', 'cls' => 'success'));
    } else {
      echo  json_encode(array('text' => 'not Updated', 'cls' => 'error'));
    }
  }

  function status(Request $request)
  {
    $state = getAny("status", "subscription", "id", $request->id);
    if ($state == 1) {
        $update_state = 2;
    }else{
        $update_state = 1;
    }
    $post = Subscription::find($request->id);
    $post->status = $update_state;
    $msg = $post->save();
    if ($msg) {
      echo  json_encode(array('text' => 'Status Changed', 'cls' => 'success'));
    } else {
      echo  json_encode(array('text' => 'Error', 'cls' => 'error'));
    }
  }

  function destroy(Request $request)
  {
    //$msg = Subscription::where('id', $request->id)->delete();
    $post = Subscription::find($request->id);
    $post->status = 0;
    $msg = $post->save();
    if ($msg) {
    echo  json_encode(array('text' => 'Delete_successfully', 'cls' => 'warning'));
    } else {
    echo  json_encode(array('text' => 'Error', 'cls' => 'error'));
    }
  }
}
