<?php
namespace App\Http\Controllers\Project;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\Project\Package;
use Response;
use Validator;
use DataTables;

class PackageController extends Controller
{
  public function index(Request $request)
  {
    //$post = Package::all()->where("status",">",0)->sortByDesc("id");
    if ($request->ajax()) {
      $data = Package::all()->where("status",">",0)->sortByDesc("id");
      return Datatables::of($data)
      ->addIndexColumn()
      ->setRowId(function ($row) { return $row->id; })
      ->addColumn('status', function($row){
          $checked = "";
          if ( $row->status == 1) { $checked = "checked"; }
          $swtich = '
            <label class="switch" for="checkbox'.$row->id.'">
                <input class="state_switch" type="checkbox" id="checkbox'.$row->id.'" value="'.$row->id.'" '.$checked.' />
                <div class="slider round"></div>
            </label>
          ';
          return $swtich;
      })
      ->addColumn('action', function($row){
          $btn = '
            <button onclick="edit_package('.$row->id.');" id="edit_sub_cat" class="btn btn-warning btn-xs">Edit</button>
            <button class="btn btn-xs btn-danger btn-delete" value="'.$row->id.'">Delete</button>
          ';
          return $btn;
      })
      ->rawColumns(['action','status'])
      ->make(true);
    }
    return view('sarf/package.package');
  }

  public function add()
  {
    //$Package = Package::where('cat_status',1)->get();
    return view('sarf/package.add');
  }

  public function save(Request $request)
  {
    $new_name = "";
    if (Package::where('name_en', $request->name_en)->exists()) {
        echo  json_encode(array('text' => 'already exists', 'cls' => 'error'));
    }
	else if (Package::where('name_ar', $request->name_ar)->exists()) {
        echo  json_encode(array('text' => 'already exists', 'cls' => 'error'));
    }
	else {
        $post = new Package;
        $post->name_en = $request->name_en;
		$post->name_ar = $request->name_ar;
        $post->duration = $request->days;
        $post->amount = $request->amount;
        $msg = $post->save();
        if ($msg) {
            echo json_encode(array('text' => 'Saved successfully', 'cls' => 'success'));
        } else {
            echo json_encode(array('text' => 'not saved', 'cls' => 'error'));
        }
    }
  }

  function edit(Request $request)
  {
    $post = Package::find($request->id);
    return view('sarf/package.edit', compact('post'));
  }

  function update(Request $request)
  {
    $post = Package::find($request->id);
    $post->name_en = $request->name_en;
	$post->name_ar = $request->name_ar;
    $post->duration = $request->days;
    $post->amount = $request->amount;
    $msg = $post->save();
    if ($msg) {
      echo  json_encode(array('text' => 'Updated successfully', 'cls' => 'success'));
    } else {
      echo  json_encode(array('text' => 'not Updated', 'cls' => 'error'));
    }
  }

  function status(Request $request)
  {
    $state = getAny("status", "package", "id", $request->id);
    if ($state == 1) {
        $update_state = 2;
    }else{
        $update_state = 1;
    }
    $post = Package::find($request->id);
    $post->status = $update_state;
    $msg = $post->save();
    if ($msg) {
      echo  json_encode(array('text' => 'Status Changed', 'cls' => 'success'));
    } else {
      echo  json_encode(array('text' => 'Error', 'cls' => 'error'));
    }
  }

  function destroy(Request $request)
  {
    //$msg = Package::where('id', $request->id)->delete();
    $post = Package::find($request->id);
    $post->status = 0;
    $msg = $post->save();
    if ($msg) {
    echo  json_encode(array('text' => 'Delete_successfully', 'cls' => 'warning'));
    } else {
    echo  json_encode(array('text' => 'Error', 'cls' => 'error'));
    }
  }
}
