<?php

namespace App\Http\Controllers\Project;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\Project\Expense_type;
use Response;
use Validator;
use DataTables;

class ExpenseTypeController extends Controller
{
    public function index(Request $request)
  {
    //$post = Expense_types::all()->where("status",">",0)->sortByDesc("id");
    if ($request->ajax()) {
      $data = Expense_type::all()->where("status",">",0)->where("type",1)->sortBy("order_by");
      return Datatables::of($data)
      ->addIndexColumn()
      ->setRowId(function ($row) { return $row->id; })
      ->addColumn('color', function($row){
          $color = '
            <button class="btn rounded-pill btn-xs text-white btn-block" style="background-color: '.$row->color.'">
              '.$row->color.'
            </button>
          ';
          return $color;
      })
      ->addColumn('status', function($row){
          $checked = "";
          if ( $row->status == 1) { $checked = "checked"; }
          $swtich = '
            <label class="switch" for="checkbox'.$row->id.'">
                <input class="state_switch" type="checkbox" id="checkbox'.$row->id.'" value="'.$row->id.'" '.$checked.' />
                <div class="slider round"></div>
            </label>
          ';
          return $swtich;
      })
      ->addColumn('action', function($row){
          $btn = '
            <button onclick="edit_category('.$row->id.');" id="edit_sub_cat" class="btn btn-warning btn-xs">Edit</button>
            <button class="btn btn-xs btn-danger btn-delete" value="'.$row->id.'">Delete</button>
          ';
          return $btn;
      })
      ->rawColumns(['action','status','color'])
      ->make(true);
    }
    return view('sarf/expense_type.expense');
  }

  public function add()
  {
    //$Expense_types = Expense_types::where('cat_status',1)->get();
    return view('sarf/expense_type.add');
  }

  public function save(Request $request)
  {
    $new_name = "";
    if (Expense_type::where('expense_name', $request->expense_name)->exists()) {
        echo  json_encode(array('text' => 'already exists', 'cls' => 'error'));
    } elseif (Expense_type::where('expense_name_ar', $request->expense_name_ar)->exists()) {
      echo  json_encode(array('text' => 'already exists', 'cls' => 'error'));
  }else {
        $post = new Expense_type;
        $post->expense_name = $request->expense_name;
        $post->expense_name_ar = $request->expense_name_ar;
        $post->color = $request->color;
        $post->order_by = $request->order_by;
        $post->type = 1;
        $msg = $post->save();
        if ($msg) {
            echo json_encode(array('text' => 'Saved successfully', 'cls' => 'success'));
        } else {
            echo json_encode(array('text' => 'not saved', 'cls' => 'error'));
        }
    }
  }

  function edit(Request $request)
  {
    $post = Expense_type::find($request->id);
    return view('sarf/expense_type.edit', compact('post'));
  }

  function update(Request $request)
  {
    $post = Expense_type::find($request->id);
    $post->expense_name = $request->expense_name;
    $post->expense_name_ar = $request->expense_name_ar;
        $post->color = $request->color;
        $post->order_by = $request->order_by;
    $msg = $post->save();
    if ($msg) {
      echo  json_encode(array('text' => 'Updated successfully', 'cls' => 'success'));
    } else {
      echo  json_encode(array('text' => 'not Updated', 'cls' => 'error'));
    }
  }

  function status(Request $request)
  {
    $state = getAny("status", "Expense_type", "id", $request->id);
    if ($state == 1) {
        $update_state = 2;
    }else{
        $update_state = 1;
    }
    $post = Expense_type::find($request->id);
    $post->status = $update_state;
    $msg = $post->save();
    if ($msg) {
      echo  json_encode(array('text' => 'Status Changed', 'cls' => 'success'));
    } else {
      echo  json_encode(array('text' => 'Error', 'cls' => 'error'));
    }
  }

  function destroy(Request $request)
  {
    //$msg = Expense_type::where('id', $request->id)->delete();
    $post = Expense_type::find($request->id);
    $post->status = 0;
    $msg = $post->save();
    if ($msg) {
    echo  json_encode(array('text' => 'Delete_successfully', 'cls' => 'warning'));
    } else {
    echo  json_encode(array('text' => 'Error', 'cls' => 'error'));
    }
  }
}
