<?php
namespace App\Http\Controllers\Project;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\Project\Colors;
use Response;
use Validator;
use DataTables;

class ColorController extends Controller
{
    public function index(Request $request)
  {
    //$post = Colors::all()->where("status",">",0)->sortByDesc("id");
    if ($request->ajax()) {
      $data = Colors::all()->where("status",">",0)->sortByDesc("id");
      return Datatables::of($data)
      ->addIndexColumn()
      ->setRowId(function ($row) { return $row->id; })
      ->addColumn('color', function($row){
          $color = '
            <button class="btn rounded-pill btn-xs text-white btn-block" style="background-color: '.$row->c_code.'">
              '.$row->c_code.'
            </button>
          ';
          return $color;
      })
      ->addColumn('status', function($row){
          $checked = "";
          if ( $row->status == 1) { $checked = "checked"; }
          $swtich = '
            <label class="switch" for="checkbox'.$row->id.'">
                <input class="state_switch" type="checkbox" id="checkbox'.$row->id.'" value="'.$row->id.'" '.$checked.' />
                <div class="slider round"></div>
            </label>
          ';
          return $swtich;
      })
      ->addColumn('action', function($row){
          $btn = '
            <button onclick="edit_category('.$row->id.');" id="edit_sub_cat" class="btn btn-warning btn-xs">Edit</button>
            <button class="btn btn-xs btn-danger btn-delete" value="'.$row->id.'">Delete</button>
          ';
          return $btn;
      })
      ->rawColumns(['action','status','color'])
      ->make(true);
    }
    return view('sarf/colors.color');
  }

  public function add()
  {
    //$Colors = Colors::where('cat_status',1)->get();
    return view('sarf/colors.add');
  }

  public function save(Request $request)
  {
    $new_name = "";
    if (Colors::where('c_code', $request->c_code)->exists()) {
        echo  json_encode(array('text' => 'already exists', 'cls' => 'error'));
    } else {
        $post = new Colors;
        $post->c_code = $request->c_code;
        $post->order_by = $request->orderby;
        $msg = $post->save();
        if ($msg) {
            echo json_encode(array('text' => 'Saved successfully', 'cls' => 'success'));
        } else {
            echo json_encode(array('text' => 'not saved', 'cls' => 'error'));
        }
    }
  }

  function edit(Request $request)
  {
    $post = Colors::find($request->id);
    return view('sarf/colors.edit', compact('post'));
  }

  function update(Request $request)
  {
    $post = Colors::find($request->id);
    $post->c_code = $request->c_code;
        $post->order_by = $request->orderby;
    $msg = $post->save();
    if ($msg) {
      echo  json_encode(array('text' => 'Updated successfully', 'cls' => 'success'));
    } else {
      echo  json_encode(array('text' => 'not Updated', 'cls' => 'error'));
    }
  }

  function status(Request $request)
  {
    $state = getAny("status", "colors", "id", $request->id);
    if ($state == 1) {
        $update_state = 2;
    }else{
        $update_state = 1;
    }
    $post = Colors::find($request->id);
    $post->status = $update_state;
    $msg = $post->save();
    if ($msg) {
      echo  json_encode(array('text' => 'Status Changed', 'cls' => 'success'));
    } else {
      echo  json_encode(array('text' => 'Error', 'cls' => 'error'));
    }
  }

  function destroy(Request $request)
  {
    //$msg = Colors::where('id', $request->id)->delete();
    $post = Colors::find($request->id);
    $post->status = 0;
    $msg = $post->save();
    if ($msg) {
    echo  json_encode(array('text' => 'Delete successfully', 'cls' => 'warning'));
    } else {
    echo  json_encode(array('text' => 'Error', 'cls' => 'error'));
    }
  }
}
