<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Response;
use DataTables;
use App\Models\Admin\User;
use Illuminate\Http\Request;
use App\Traits\Permissions_trait;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Spatie\Activitylog\Models\Activity;

class UserController extends Controller
{
    var $url;
    var $user;
    use Permissions_trait;
    public function __construct()
    {
        $this->middleware('auth');
        $this->url = request()->path();
        $this->user = Auth::user();
    }
    public function index(Request $request)
    {
        if (!$this->Permissions_trait('view', $this->url)) :
            abort(403, 'Permission denied..');
        endif;

        if ($request->ajax()) {
            $data = User::all()->where('type','admin');
            return Datatables::of($data)
            ->addIndexColumn()
            ->setRowId(function ($row) { return $row->id; })
            ->addColumn('action', function($row){
                $btn = '';


                if($this->Permissions_trait('update',$this->url)):
				if($row->user_type != '5'){
                     $btn .= '<a type="button" class="btn btn-outline-secondary btn-xs" onClick="edit_user('.$row->id.');"><i class="bi-pencil-square" style="font-size:16;line-height:0;"></i></a>';
				}else{
					$btn = "Said Admin";
				}
                endif;
                if ($this->Permissions_trait('delete', $this->url)) :
				
				if($row->user_type != '5'){ //5 is super admin
                    $btn .= '<a type="button" class="btn btn-outline-danger btn-xs" onClick="delete_user(' . $row->id . ');"><i class="bi-trash-fill" style="font-size:16;line-height:0;"></i></a>';
				}
                endif;

                return $btn;
            })
            ->rawColumns(['action'])
            ->make(true);
        }

        activity('Manage Users Page visited')
        ->causedBy(Auth::user())
            ->performedOn(new User())
            // ->withProperties(['old'  => [Socials::find($request->id)], 'modified' => $data])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('Manage Users Page visited by ' . Auth::user()->name);
        return view('admin.users.manage_users');
    }

    public function addModel(){

        $allRoles = Role::get();
        return view('admin.users.user_add',compact('allRoles'));
    }

    public function save(Request $request){
        $role = Role::find($request->u_role)->name;
		$type = "admin";
        $data = [
            'name' => $request->u_name,
            //'name_ar = $request->u_name_ar,
            'email' => $request->u_email,
            'role' => $request->u_role,
			'type' => $type,
			 'user_type' => 0,
        
            'password' => Hash::make($request->u_password),
        ];
        $post = User::create($data);
        // $post->syncRoles($role);
        if(!$post->hasRole($role)):
            $post->removeRole($role);
        endif;
        $post->assignRole($role);
        unset($data['password']);
        activity('Data Added in Manage User page')
        ->causedBy(Auth::user())
            ->performedOn(new user())
            ->withProperties(['old'  => [], 'modified' => $data])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log(' Manage User data added by ' . Auth::user()->name);
        if ($post) {
            return ['text'=> trans('admin.saved_successfully'),'cls'=>'success'];
        } else {
            return ['text'=> trans('admin.not_saved'),'cls'=>'error'];
        }
    }

    function editModel(Request $request){
        $user = User::find($request->id);
        // dd(Auth::user()->locale);
        $roles = $user->getRoleNames();
        $allRoles = Role::get();
        return view('admin.users.user_edit',compact('user','roles','allRoles'));
    }

    function update(Request $request){
        $post = User::find($request->id);
        $role = Role::find($request->u_role)->name;
        $data = [
            'name' => $request->u_name,
            'email' => $request->u_email,
        ];
        if($request->u_password){
            $data['password'] = Hash::make($request->u_password);
        }
        $msg = User::where('id', $request->id)->update($data);
        if ($post->hasRole($role)) :
            $post->removeRole($role);
        endif;
        $post->assignRole($role);

        unset($data['password']);
        activity('User Data updated in Manage Users page')
        ->causedBy(Auth::user())
            ->performedOn(new user())
            ->withProperties(['old'  => $post, 'modified' => $data])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('User data updated by ' . Auth::user()->name);
        if ($msg) {
            return ['text'=> trans('admin.Updated_successfully'),'cls'=>'success'];
        } else {
            return ['text'=> trans('admin.not_Updated'),'cls'=>'error'];
        }
    }

    function destroy(Request $request){
        activity('User Data deleted from Manage user page')
        ->causedBy(Auth::user())
        ->performedOn(new user())
        ->withProperties(['old'  => User::find($request->id), 'modified' => []])
        ->tap(function (Activity $activity) {
            $activity->route_link = $this->url;
        })
        ->log('User data Deleted by ' . Auth::user()->name);

        $msg = User::where('id', $request->id)->delete();

        if ($msg) {
            echo  json_encode(array('text'=> trans('admin.Delete_successfully'),'cls'=>'success'));
        } else {
            echo  json_encode(array('text'=> trans('admin.Error'),'cls'=>'error'));
        }
    }
}
