<?php
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Admin\Theme;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\Admin\Language;
use App\Models\Admin\SiteInfo;
use App\Models\Admin\Pages;
use App\Models\Admin\Socials;
use App\Models\Admin\ContactUs;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Validator;

use App\Traits\Permissions_trait;
use Spatie\Activitylog\Models\Activity;

class ThemeController extends Controller
{
    use Permissions_trait;
    var $url;
    var $settings;
    public function __construct()
    {
        //$this->middleware('auth');
        $this->url = request()->path();
        $this->settings = Theme::where('status', 1)->first()->settings;
    }

    public function index()
    {
        return Theme::all();
    }

    public function home()
    {
        $site_info = SiteInfo::first();
        $theme = Theme::where('status', 1)->get()->first();
        $socials = Socials::where('status', 1)->get()->toArray();
        // dd($socials);
        $data = ['settings' => $theme->settings, 'dir' => $theme->dir, 'locale' => app()->getLocale(), 'socials' => $socials, 'site_info' => $site_info]; //dd($data['settings']);
        // dd($data);
        return view("frontend.".$theme->dir.".home", $data);
    }

    public function privacy()
    {
        $site_info = SiteInfo::first();
        $theme = Theme::where('status', 1)->get()->first();
        $data = Pages::where('slug', 'privacy')->first();

        $socials = Socials::where('status', 1)->get()->toArray();
        $ndata = ['settings' => $theme->settings, 'dir' => $theme->dir, 'content' => $data, 'locale' => app()->getLocale(), 'socials' => $socials, 'site_info' => $site_info];
        return view("frontend.privacy", $ndata);
    }

    public function terms()
    {
        $site_info = SiteInfo::first();
        $theme = Theme::where('status', 1)->get()->first();
        $data = Pages::where('slug', 'terms')->first();

        $socials = Socials::where('status', 1)->get()->toArray();
        $ndata = ['settings' => $theme->settings, 'dir' => $theme->dir, 'content' => $data, 'locale' => app()->getLocale(), 'socials' => $socials, 'site_info' => $site_info];
        return view("frontend.terms", $ndata);
    }

    public function settings()
    {
        // $data = Theme::where('status', 1)->first()->settings;
        $data = $this->settings;
        $sorted_data['topbar'] = $data['topbar'];
        $sorted_data['header'] = $data['header'];
        $sorted_data['about'] = $data['about'];
        $sorted_data['features'] = $data['features'];
        $sorted_data['slider'] = $data['slider'];
        $sorted_data['download'] = $data['download'];
        $sorted_data['footer'] = $data['footer'];
        $sorted_data['contact_form'] = $data['contact_form'];
        $sorted_data['footer_bar'] = $data['footer_bar'];

        $data = $sorted_data;
        // dd($sorted_data);
        // dd($data);
        return view('admin.frontend.homepage',compact('data'));
    }

    public function change_status(Request $request)
    {
        $val = ($request->value == '1') ? false : true;
        $section = $request->section;
        $data = $this->settings;
        $data[$section]['hide'] = $val;
        Theme::where('id',1)->update(['settings'=>$data]);
        return ['text' => 'Updated','cls' => 'success'];

    }

    public function show($section)
    {
        $data = $this->settings;
        // $data['download']['photo'] = "";
        $section = Crypt::decrypt($section);
        $data = $this->settings;

        $language = Language::get();

        $default = Language::where('is_default','1')->first()->abbr;
        $view = null;

        // dd($data[$section],$section);
        switch ($section) {
            case 'header':
                $view = 'admin.frontend.header';
                break;
            case 'about':
                $view = 'admin.frontend.about';
                break;
            case 'topbar':
                $view = 'admin.frontend.topbar';
                break;
            case 'footer_bar':
                $view = 'admin.frontend.footer_bar';
                break;
            case 'slider':
                $view = 'admin.frontend.slider';
                break;
            case 'download':
                $view = 'admin.frontend.download';
                break;
            case 'contact_form':
                $view = 'admin.frontend.contact_form';
                break;
            case 'footer':
                $view = 'admin.frontend.footer';
                break;
            case 'features':
                $view = 'admin.frontend.features';
                break;
        }
        // dd($data[$section]);
        return view($view)->with(['data' => $data[$section],'language' => $language,'section' =>$section,'default' => $default ]);
    }

    public function update(Request $request)
    {
        switch ($request->section) {
            case 'header':
                $status = $this->header($request);
                break;
            case 'about':
                $status = $this->updateAboutSection($request);
                break;
            case 'footer_bar':
                $status = $this->footer_bar($request);
                break;
            case 'topbar':
                $status = $this->topbar($request);
                break;
            case 'slider':
                $status= $this->slider($request);
                break;
            case 'features':
                $status = $this->features($request);
                break;
            case 'download':
                $status = $this->download($request);
                break;
            case 'contact_form':
                $status = $this->contact_form($request);
                break;
            case 'footer':
                $status = $this->footer($request);
                break;
        }
        return redirect()->back()->with($status);

    }

    public function updateAboutSection($request)
    {
        // dd($request->all());
        $request->validate([
            'heading' => 'required',
            'sub_heading' => 'required',
            'language' => 'required',
            'heading_color' => 'required',
            'sub_heading_color' => 'required',
            'photo' =>  'mimes:png,jpg,jpeg',
        ]);
        $data = $this->settings;
        if ($request->has('photo')) :
            if (File::exists(public_path($data[$request->section]['photo']))) {
                File::delete(public_path($data[$request->section]['photo']));
            }
            $photoFile = $request->photo;
            $photo = 'project/frontend/'. Str::random(30) . "." . $photoFile->getClientOriginalExtension();
            // dd($photo);
            $photoFile->move(public_path('project/frontend/'), $photo);
            $data[$request->section]['photo'] = $photo;
        endif;
        $data[$request->section]['heading'][$request->language] = $request->heading;
        $data[$request->section]['sub_heading'][$request->language] = $request->sub_heading;

        $data[$request->section]['colors']['heading_color'] = $request->heading_color;
        $data[$request->section]['colors']['sub_heading_color'] = $request->sub_heading_color;
        Theme::where('id',1)->update(['settings' => $data]);
        return ['success' => 'updated successfully'];
    }

    public function footer_bar($request)
    {
        // dd($request->all());
        $request->validate([
            'language' => 'required',
            'copy_right' => 'required',
            'privacy_and_policy_name' => 'required',
            // 'privacy_and_policy_link' => 'required',
            'terms_and_condetion_name' => 'required',
            // 'terms_and_condetion_link' =>  'required',
        ]);

        $data = $this->settings;
        $data[$request->section]['colors']['text_color'] = $request->text_color;
        $data[$request->section]['colors']['heading_color'] = $request->heading_color;
        $data[$request->section]['colors']['background_color'] = $request->background_color;

        $data[$request->section]['copy_right']['name'][$request->language] = $request->copy_right;

        $data[$request->section]['privacy_policy']['name'][$request->language] = $request->privacy_and_policy_name;
        // $data[$request->section]['privacy_policy']['link']= $request->privacy_and_policy_link;

        $data[$request->section]['terms_and_condetion']['name'][$request->language] = $request->terms_and_condetion_name;
        // $data[$request->section]['terms_and_condetion']['link'] = $request->terms_and_condetion_link;
        // dd($data['footer_bar']);
        Theme::where('id', 1)->update(['settings' => $data]);
        return ['success' => 'updated successfully'];
    }

    public function topbar($request)
    {

        $request->validate([
            // 'language' => 'required',
            'photo' =>  'mimes:png,jpg,jpeg',
        ]);

        $data = $this->settings;

        $data[$request->section]['colors']['text_color'] = $request->text_color;
        $data[$request->section]['colors']['background_color'] = $request->background_color;

        if ($request->has('photo')) :
            if (File::exists(public_path($data[$request->section]['photo']))) {
                File::delete(public_path($data[$request->section]['photo']));
            }
            $photoFile = $request->photo;
            $photoName = Str::random(30) . "." . $photoFile->getClientOriginalExtension();
            $photo = 'project/frontend/' . $photoName;
            // dd($photo);
            $photoFile->move(public_path('project/frontend/'), $photoName);
            $data[$request->section]['photo'] = $photo;
        endif;
        Theme::where('id', 1)->update(['settings' => $data]);
        return ['success' => 'updated successfully'];
    }

    public function slider($request)
    {

        $request->validate([
            'language' => 'required',
            'photo' =>  'mimes:png,jpg,jpeg',
            'heading' => 'required',
            'sub_heading' => 'required',
            'slider.*' => 'mimes:png,jpg,jpeg'
        ]);
        $data = $this->settings;
        $data[$request->section]['colors']['text_color'] = $request->text_color;
        $data[$request->section]['colors']['heading_color'] = $request->heading_color;
        $data[$request->section]['colors']['background_color'] = $request->background_color;
        $data[$request->section]['heading'][$request->language] = $request->heading;
        $data[$request->section]['sub_heading'][$request->language] = $request->sub_heading;
        // dd($data[$request->section]);
        if ($request->has('slider')) :

            foreach($request->slider as $item):
                $photo = 'project/frontend/slider/' . Str::random(20) . "." . $item->getClientOriginalExtension();
                $item->move(public_path('project/frontend/slider/'), $photo);
                array_push($data[$request->section]['photos'],$photo);
            endforeach;

        endif;
        Theme::where('id', 1)->update(['settings' => $data]);
        return ['success' => 'updated successfully'];
    }

    public function delete_slider($slider,$section)
    {
        $slider = str_replace('-','/',$slider);
        $data = $this->settings;
        $photo = $data[$section]['photos'];
        $key = array_search($slider, $photo);
        if (false !== $key) {
            unset($photo[$key]);
            if (File::exists(public_path($slider))) {
                File::delete(public_path($slider));
            }
            $data[$section]['photos'] = $photo;
            Theme::where('id', 1)->update(['settings' => $data]);

            return ['text' => "deleted..",'cls' => 'success'];
        }else{
            return ['text' => "error..", 'cls' => 'error'];
        }

    }

    public function features($request)
    {
        $validator = Validator::make($request->all(),[
            'language.*' => 'required',
            'content.*' => 'required',
            'title.*' => 'required',
            'photo.*' => 'mimes:png,jpg'
        ])->validate();


        $data = $this->settings;


        for ($i=0; $i <count($request->title) ; $i++) {
            $data['features'][$i]['colors']['title_color'] = $request->title_color[$i];
            $data['features'][$i]['colors']['text_color'] = $request->text_color[$i];
            $data['features'][$i]['direction'] = $request->direction[$i];
            $data['features'][$i]['title'][$request->language[$i]] = $request->title[$i];
            $data['features'][$i]['content'][$request->language[$i]] = $request->content[$i];
            if($request->has('photo') && isset($request->photo[$i])):
                if (File::exists(public_path($data[$request->section][$i]['photo']))) {
                    File::delete(public_path($data[$request->section][$i]['photo']));
                }
                $item = $request->photo[$i];
                $photo[$i] = 'project/frontend/features/' . Str::random(20) . "." . $item->getClientOriginalExtension();
                $item->move(public_path('project/frontend/features/'), $photo[$i]);
                $data['features'][$i]['photo'] = $photo[$i];
            endif;
        }

        Theme::where('id', 1)->update(['settings' => $data]);
        // $request->session()->flash('status', 'Task was successful!');
        return ['success' => 'updated successfully'];
    }

    public function download($request)
    {
        $request->validate([
            'language' => 'required',
            'description' => 'required',
            'title' => 'required',
            'photo' => 'mimes:png,jpg,jpeg'
        ]);

        $record = Theme::where('id',1)->select('settings')->first()->settings;
        // $data = $this->settings
        // dd($record);
        if ($request->has('photo')) :
            if (File::exists(public_path($record[$request->section]['photo']))) {
                File::delete(public_path($record[$request->section]['photo']));
            }
            $item = $request->photo;
            $rand = Str::random(20);
            $photo = 'project/frontend/download/' . $rand . "." . $item->getClientOriginalExtension();
            $item->move(public_path('project/frontend/download/'), $photo);
            $record['download']['photo'] = $photo;
        endif;
        $record['download']['title'][$request->language] = $request->title;
        $record['download']['description'][$request->language] = $request->description;
        $record['download']['appstore_link'] = $request->appstore;
        $record['download']['playstore_link'] = $request->playstore;
        $record['download']['colors']['text_color'] = $request->text_color;
        $record['download']['colors']['heading_color'] = $request->heading_color;
        $record['download']['colors']['background_color'] = $request->background_color;

        Theme::where('id', 1)->update(['settings' => $record]);
        $this->settings = Theme::where('id', 1)->first()->settings;
        // dd($ok['download']['photo']);
        return ['success' => 'updated successfully'];
    }

    public function contact_form($request)
    {

        $data = $this->settings;
        $data[$request->section]['colors']['button_background'] = $request->button_background;
        $data[$request->section]['colors']['button_foreground'] = $request->button_foreground;
        $data[$request->section]['colors']['inputs_background'] = $request->inputs_background;
        $data[$request->section]['colors']['inputs_foreground'] = $request->inputs_foreground;

        Theme::where('id', 1)->update(['settings' => $data]);
        return ['success' => 'updated successfully'];
    }

    public function footer($request)
    {

        $request->validate([
            'title' => 'required',
            'description' => 'required',
            'language' => 'required',
        ]);
        $data = $this->settings;
        $data[$request->section]['colors']['text_color'] = $request->text_color;
        $data[$request->section]['colors']['title_color'] = $request->title_color;
        $data[$request->section]['colors']['background_color'] = $request->background_color;
        $data[$request->section]['colors']['description_color'] = $request->description_color;
        $data[$request->section]['title'][$request->language] = $request->title;
        $data[$request->section]['description'][$request->language] = $request->description;



        Theme::where('id', 1)->update(['settings' => $data]);
        return ['success' => 'updated successfully'];
    }

    public function header($request)
    {
        $request->validate([
            'title' => 'required',
            'description' => 'required',
            'language' => 'required',
            'photo' => 'mimes:png,jpg'
        ]);
        $data = $this->settings;
        // dd($data[$request->section]);
        $data[$request->section]['colors']['heading_color'] = $request->heading_color;
        $data[$request->section]['colors']['background_color'] = $request->background_color;
        $data[$request->section]['colors']['sub_heading_color'] = $request->sub_heading_color;
        $data[$request->section]['title'][$request->language] = $request->title;
        $data[$request->section]['description'][$request->language] = $request->description;
        // dd($request->all());
        // dd($data[$request->section]);
        if ($request->has('photo')) :
            if (File::exists(public_path($data[$request->section]['photo']))) {
                File::delete(public_path($data[$request->section]['photo']));
            }
            $item = $request->photo;
            $photo = 'project/frontend/header/' . Str::random(20) . "." . $item->getClientOriginalExtension();
            $item->move(public_path('project/frontend/header/'), $photo);
            $data[$request->section]['photo'] = $photo;

        endif;
        Theme::where('id', 1)->update(['settings' => $data]);
        return ['success' => 'updated successfully'];
    }

    public function contact_msg_save(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|max:255',
            'email' => 'required|email',
            'text' => 'required',
        ]);

        if ($validator->fails()) {
            echo json_encode(array('text' => 'Please check your data (name, email, message is required)', 'cls' => 'error'));

        } else {
            $data = [
                'name' => $request->name,
                'mobile' => $request->mobile,
                'email' => $request->email,
                'text' => $request->text,
            ];
            $post = ContactUs::insert($data);
            if ($post) {
                echo  json_encode(array('text' => 'Send successfully', 'cls' => 'success'));
            } else {
                echo  json_encode(array('text' => 'Message not send', 'cls' => 'error'));
            }

        }
    }

    public function theme_appearance()
    {
        if (!$this->Permissions_trait('view', 'themes')) :
            abort(403, 'Permission denied..');
        endif;
        $post = Theme::first();
        return view('admin/themes.index', compact('post'));
    }

    public function activate_theme(Request $request)
    {
        // dd($request->all());
        if(!$this->Permissions_trait('update','themes')):
            return redirect()->back()->with('error', trans('Permission denied..'))->withInput();
            //abort(403, 'Permission denied..');
            exit;
        endif;
        $data = [
            'slug' => $request->slug,
            'dir' => $request->slug,
        ];
        $post = Theme::whereId(Theme::first()->id)->update($data);
        if ($post) {
            return redirect()->back()->with('success','Aactivated')->withInput();

        } else {
            return redirect()->back()->with('error','Error activiting theme.')->withInput();

        }
    }

    public function theme_settings($id)
    {
        if (!$this->Permissions_trait('view', 'themes')) :
            abort(403, 'Permission denied..');
        endif;
        $id = Crypt::decrypt($id);
        $post = Theme::whereId($id)->orderBy('id')->get();
        return view('admin/themes.theme_settings', compact('post'));
    }

    public function edit_theme_setting(Request $request)
    {
        if(!$this->Permissions_trait('update','themes')):
            return redirect()->back()->with('error', trans('Permission denied..'))->withInput();
            //abort(403, 'Permission denied..');
            exit;
        endif;
        // code for settings hammad sb
    }
}
