<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\Admin\Support;
use App\Models\Admin\SupportChat;
use Carbon\Carbon;
use Yajra\DataTables\DataTables;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;

use App\Traits\Permissions_trait;
use Spatie\Activitylog\Models\Activity;

class SupportController extends Controller
{
    use Permissions_trait;
    var $url;
    public function __construct()
    {
        $this->middleware('auth');
        $this->url = request()->path();
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        if (!$this->Permissions_trait('view', $this->url)) :
            abort(403, 'Permission denied..');
        endif;
        if ($request->ajax()) {
          $record = Support::select('*')->orderBy('id', 'desc');
          return Datatables::of($record)
          ->addIndexColumn()
          ->setRowId(function ($row) { return $row->id; })
          ->addColumn('user_id', function($row){

            $user_type = userInfo($row->user_id, "user_type");
            if($user_type == 1){
                $user_type = 'Customer';
            }
            elseif($user_type == 2){
                $user_type = 'Provider';
            }
            $div='
                <table>
                    <tr>
                        <td> <img class="px-2" src="'.asset('images/user/'.userInfo($row->user_id, 'photo')).'" alt=""></td>
                        <td>
                            <sapn class="fw-bold text-dark">'.userInfo($row->user_id).'</sapn><br>
                            <span>'.$user_type.'</span>
                        </td>
                    </tr>
                </table>
            ';
            return $div;
          })
          ->addColumn('id', function($row){
              return "#".$row->id;
          })
          ->addColumn('created_at', function ($row) {
                return Carbon::parse($row->created_at) -> format('d F, Y');
          })
          ->addColumn('status', function($row){
            switch ($row->status) {
                case 0:
                    return '<div class="mb-3">
                        <select data-id="'.$row->id.'" id="active_status" class="form-select rounded-pill bg-c text-white bg-danger border-0">
                            <option value="0" selected> Inactive </option>
                            <option value="1"> Pending </option>
                            <option value="2"> Active </option>
                            <option value="3"> Completed </option>
                        </select>
                    </div>';
                    break;
                case 1:
                    return '<div class="mb-3">
                        <select data-id="'.$row->id.'" id="active_status" class="form-select rounded-pill bg-c text-white bg-danger border-0">
                            <option value="0" > Inactive </option>
                            <option value="1" selected> Pending </option>
                            <option value="2" > Active </option>
                            <option value="3" > Completed </option>
                        </select>
                    </div>';
                    break;
                case 2:
                    return '<div class="mb-3">
                        <select data-id="'.$row->id.'" id="active_status" class="form-select rounded-pill bg-c text-white bg-danger border-0">
                            <option value="0" > Inactive </option>
                            <option value="1" > Pending </option>
                            <option value="2" selected> Active </option>
                            <option value="3" > Completed </option>
                        </select>
                    </div>';
                    break;
                case 3:
                    return '<div class="mb-3">
                        <select data-id="'.$row->id.'" id="active_status" class="form-select rounded-pill bg-c text-white bg-danger border-0">
                            <option value="0" > Inactive </option>
                            <option value="1" > Pending </option>
                            <option value="2" > Active </option>
                            <option value="3" selected> Completed </option>
                        </select>
                    </div>';
                    break;
            }
          })
          ->addColumn('action', function($row){
              $btn = '
              <div class="float-center">
                <span class="px-2">
                    <a class="text-decoration-none px-1" href="'.url("/support/support_view/".$row->id).'">
                        <span class="edit_icon">
                            <i class="bi bi-eye" style="font-size: 16px;"></i>
                        </span>
                        <span class="px-1 e-text">Veiw</span>
                    </a>
                </span>
                </div>
              ';
              return $btn;
          })
          ->filter(function ($record) use ($request) {
              /*search*/
              $input=$user_id="";
              if ($request->has('search_new') && $request->search_new != "") {
                $input=$request->get("search_new");
                if (isset(User::where('name', 'like', '%'. $input .'%')->first()->id)) {
                    $user_id = User::where('name', 'like', '%'. $input .'%')->first()->id;
                    $record->where('user_id', 'like', '%'. $user_id .'%');
                }
                else{
                    $record->where('id', 'like', '%'. $input .'%')->orwhere('net_total', 'like', '%'. $input .'%');
                }
              }
              /*status*/
              if ($request->has('status_filter') && $request->status_filter != "") {
                $record->where('status', '=', $request->get('status_filter'));
              }
          })
          ->rawColumns(['action','status','user_id'])
          ->make(true);
        }
        activity('Support Page Visited')
           ->causedBy(Auth::user())
            ->performedOn(new Support())
            // ->withProperties(['old'  => [], 'modified'=>$data])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('Support Page visited by ' . Auth::user()->name);
        return view('admin.support.support_manage');
    }

    public function status_change($id, $status)
    {
        if(!$this->Permissions_trait('update','support')):
            echo  json_encode(array('text' => trans('Permission denied..'), 'cls' => 'error'));
            //abort(403, 'Permission denied..');
            exit;
        endif;
        Support::where('id',$id)->update([
            'status' => $status
        ]);
        // HERE
        activity('Status Changed in support page')
        ->causedBy(Auth::user())
            ->performedOn(new Support())
            ->withProperties(['old'  => [], 'modified' => ['status' => $status]])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('Status Changed in support page by ' . Auth::user()->name);
        return ['status' => 'success','message' => 'Modified'];
    }

    public function support_view($id)
    {
        $post = Support::find($id)->first();
        $postMsg = SupportChat::where('support_id', $id)->get();
        return view('admin.support.support_view', compact('post','postMsg'));
    }

    public function support_reply(Request $request)
    {
        if (!$this->Permissions_trait('insert', 'support')) :
            return redirect()->back()->with('error','Permission denied..')->withInput();
            //abort(403, 'Permission denied..');
            exit;
        endif;
        $validator = Validator::make($request->all(), [
            'text' => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        } else {
            $data = [
                'support_id' => $request->id,
                'user_id' => Auth::id(),
                'message' => $request->text,
                //'type' => $request->type,
            ];
            $post = SupportChat::insert($data);
            activity('Support Chat Reply send')
               ->causedBy(Auth::user())
                ->performedOn(new SupportChat())
                // ->withProperties(['old'  => [], 'modified'=>$data])
                ->tap(function (Activity $activity) {
                    $activity->route_link = $this->url;
                })
                ->log('Support Chat Reply send by ' . Auth::user()->name);
            if ($post) {
                return redirect()->back()->with('success','Send successfuly')->withInput();
            } else {
                return redirect()->back()->with('error','Somthing went wrong')->withInput();
            }
        }
    }
}
