<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;

use Response;
use Validator;
use DataTables;
use App\Models\Admin\Socials;
use App\Models\Admin\SiteInfo;
use Illuminate\Http\Request;
use App\Traits\Permissions_trait;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Models\Activity;

class SiteController extends Controller
{
    var $url;
    use Permissions_trait;
    public function __construct()
    {
        $this->middleware('auth');
        $this->url = request()->path();
    }
    public function index(Request $request)
    {
        if (!$this->Permissions_trait('view', $this->url)) :
            abort(403, 'Permission denied..');
        endif;
        if (!isset(SiteInfo::first()->id)) {
            $data = [
              'site_title' => "Enter site title",
            ];
            $msg = SiteInfo::insert($data);
        }
        $info = SiteInfo::first();
        activity('Site Info page visited')
        ->causedBy(Auth::user())
            ->performedOn(new SiteInfo())
            // ->withProperties(['old'  => [Role::find($request->id)], 'modified' => []])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('Site info Page visited by ' . Auth::user()->name);
        return view('admin/site_configration.site_info',compact('info'));
    }

  //update site info
    function update(Request $request)
    {
        if(!$this->Permissions_trait('update','site_info')):
            return redirect()->back()->with('error','Permission denied..')->withInput();
            //abort(403, 'Permission denied..');
            exit;
        endif;
        $post = SiteInfo::find($request->id);
        $validation = Validator::make($request->all(), [
            /*'photo' => 'image|mimes:jpeg,png,jpg,gif|max:2048',
            'favicon' => 'image|mimes:jpeg,png,jpg,gif|max:2048',*/
            'site_title' => 'required|max:255',
            'site_description_en' => 'required',
            'site_descrition_ar' => 'required',
            'site_keyword_en' => 'required',
            'site_keyword_ar' => 'required',
        
        ]);

        if ($validation->passes()) {
            $photo = $request->file('photo');
            if ($photo) {
                $new_name = rand() . '.' . $photo->getClientOriginalExtension();
                $photo->move(public_path('project/logo/'), $new_name);
            } else {
                $new_name = $post->photo;
            }

            $favicon = $request->file('favicon');
            if ($favicon) {
                $new_name2 = rand() . '.' . $favicon->getClientOriginalExtension();
                $favicon->move(public_path('project/logo/'), $new_name2);
            } else {
                $new_name2 = $post->favicon;
            }
            $data = [
            'site_title' => $request->site_title,
            'site_description_en' => $request->site_description_en,
            'site_descrition_ar' => $request->site_descrition_ar,
            'site_keyword_en' => $request->site_keyword_en,
            'site_keyword_ar' => $request->site_keyword_ar,
            'photo' => $new_name,
            'favicon' => $new_name2,
            ];
            $msg = SiteInfo::where('id',$request->id)->update($data);
            activity('Site Info Data Updated')
            ->causedBy(Auth::user())
            ->performedOn(new SiteInfo())
            ->withProperties(['old'  => [], 'modified' => $data])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('Site Info Data updated by ' . Auth::user()->name);
        if ($msg) {
            return redirect()->back()->with('success', trans('admin.Updated_successfully'))->withInput();
        } else {
            return redirect()->back()->with('success', trans('admin.not_Updated'))->withInput();
        }
        } else {
        return redirect()->back()->withErrors($validation)->withInput();
        }
    }
  //end update profile info

  /*socials start*/
  public function socials(Request $request)
  {
      if(!$this->Permissions_trait('view',$this->url)):
        abort(403,'Access denied');
      endif;
    if ($request->ajax()) {
      $data = Socials::all()->sortByDesc("id");
      return Datatables::of($data)
      ->addIndexColumn()
      ->setRowId(function ($row) { return $row->id; })
      ->addColumn('icon', function($row){
          $icon = '
            <span class="bi '.$row->icon.'"></span>
          ';
          return $icon;
      })
      ->addColumn('status', function($row){
          $checked = "";
          if ( $row->status == 1) { $checked = "checked"; }
          $swtich = '
            <label class="switch" for="checkbox'.$row->id.'">
                <input class="state_switch" type="checkbox" id="checkbox'.$row->id.'" value="'.$row->id.'" '.$checked.' />
                <div class="slider round"></div>
            </label>
          ';
        if ($this->Permissions_trait('update', 'socials')) :
            return $swtich;
        endif;
      })
      ->addColumn('action', function($row){
          $btn = "";
            if ($this->Permissions_trait('update', $this->url)) :
            $btn .= '<button onclick="edit_category('.$row->id.');" id="edit_sub_cat" class="btn btn-warning btn-xs">Edit</button>';
            endif;
            if ($this->Permissions_trait('delete', $this->url)) :
            $btn .= '<button class="btn btn-xs btn-danger btn-delete" value="'.$row->id.'">Delete</button>';
            endif;
          return $btn;
      })
      ->rawColumns(['action','status','icon'])
      ->make(true);
    }

        activity('Social Page is visited')
        ->causedBy(Auth::user())
            ->performedOn(new Socials())
            // ->withProperties(['old'  => [Role::find($request->id)], 'modified' => []])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('Social Page is visited by ' . Auth::user()->name);
    return view('admin/site_socials.socials');
  }

  public function addModelSocials()
  {
    //$category = Category::where('cat_status',1)->get();
    return view('admin/site_socials.add');
  }

  public function saveSocials(Request $request)
  {
    if (!$this->Permissions_trait('insert', 'socials')) :
       return ['text' => trans('admin.Permission_denied'),'cls' => 'error'];
    endif;
    $new_name = "";
    if (Socials::where('link', $request->link)->exists()) {
      return ['text' => 'already exists', 'cls' => 'error'];
    } else {
     $data = [
        'icon' => $request->icon,
        'link'=> $request->link,
        'status' => '1',
        'created_at' => date('Y-m-d H:i:s'),
     ];
     $msg = Socials::insert($data);

      //   $post->orderby = $request->orderby;

      activity('Social Media data added')
      ->causedBy(Auth::user())
          ->performedOn(new Socials())
          ->withProperties(['old'  => [], 'modified' => $data])
          ->tap(function (Activity $activity) {
              $activity->route_link = $this->url;
          })
          ->log('Socials Media Data added by ' . Auth::user()->name);
        
      if ($msg) {
        return ['text' => 'Saved successfully', 'cls' => 'success'];
      } else {
        return ['text' => 'not saved', 'cls' => 'error'];
      }
    }
  }

  function editModelSocials(Request $request)
  {
    $post = Socials::find($request->id);
    return view('admin/site_socials.edit', compact('post'));
  }

  function updateSocials(Request $request)
  {
      $socials = Socials::find($request->id);
      $data = [
        'icon' => $request->icon,
        'link' => $request->link,
        'updated_at' => date('Y-m-d H:i:s'),
      ];

        activity('Social Media Data updated')
        ->causedBy(Auth::user())
            ->performedOn(new Socials())
            ->withProperties(['old'  => $socials, 'modified' => $data])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('Social Media data updated by ' . Auth::user()->name);
            Socials::where('id',$request->id)->update($data);

      return ['text' => trans('admin.Updated_successfully'), 'cls' => 'success'];
  }

  function statusSocials(Request $request)
  {
    $state = getAny("status", "socials", "id", $request->id);
    if ($state == 1) {
        $update_state = 2;
    }else{
        $update_state = 1;
    }

    activity('Social Status Changed')
    ->causedBy(Auth::user())
        ->performedOn(new Socials())
        ->withProperties(['old'  => ['status' => $state->status], 'modified' => ['status' => $update_state]])
        ->tap(function (Activity $activity) {
            $activity->route_link = $this->url;
        })
        ->log('Social Status changed by ' . Auth::user()->name);
    $post = Socials::find($request->id);
    $post->status = $update_state;
    $msg = $post->save();

    if ($msg) {
      return ['text' => 'Status Changed', 'cls' => 'success'];
    } else {
      return ['text' => 'Error', 'cls' => 'error'];
    }
  }

  function destroySocials(Request $request)
  {

        activity('Social Media Data deleted')
        ->causedBy(Auth::user())
            ->performedOn(new Socials())
            // ->withProperties(['old'  => [Socials::find($request->id)], 'modified' => $data])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('Social Media data deleted by ' . Auth::user()->name);
    $msg = Socials::where('id', $request->id)->delete();

     return ['text' => trans('admin.Delete_successfully'), 'cls' => 'warning'];
  }
  /*social end*/

}
