<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use App\helpers\Malath_SMS;

use App\Models\Admin\SmsHost;
use App\Models\Admin\SmsTemplate;
use App\Models\Admin\User;
use Yajra\DataTables\DataTables;

use App\Traits\Permissions_trait;
use Spatie\Activitylog\Models\Activity;

class SMSController extends Controller
{

    use Permissions_trait;
    var $url;
    public function __construct()
    {
        $this->middleware('auth');
        $this->url = request()->path();
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(){
        if (!$this->Permissions_trait('view', $this->url)) :
            abort(403, 'Permission denied..');
        endif;
        activity('SMS Hosts Page Visited')
        ->causedBy(Auth::user())
         ->performedOn(new User())
         // ->withProperties(['old'  => [], 'modified'=>$data])
         ->tap(function (Activity $activity) {
             $activity->route_link = $this->url;
         })
         ->log('SMS Hosts Page visited by ' . Auth::user()->name);
        return View('admin.sms.sms_hosts');

    }

    public function host_list(Request $request)
    {
        if (!$this->Permissions_trait('view', 'sms_hosts')) :
            abort(403, 'Permission denied..');
        endif;
        if ($request->ajax()) :
            $record = SmsHost::select('*')->where('status', '!=', -1)->orderByDesc('id');
            return Datatables::of($record)
            ->setRowId(function ($row) {
                return $row->id;
            })
            ->addColumn('is_default',function ($row) {
                $checked = "";
                  if ($row->is_default == 1) { $checked = "checked"; }
                  $swtich = '
                  <div class="ps-5 text-center">
                      <label class="switch">
                          <input class="" type="checkbox" id="togBtn" onClick="is_default('.$row->id.')" '.$checked.'>
                          <div class="slider round">
                              <span class="on">ON</span>
                              <span class="off">OFF</span>
                          </div>
                      </label>
                  </div>
                  ';
                  return $swtich;
            })
            ->addColumn('status',function ($row) {
                $checked = "";
                  if ($row->status == 1) { $checked = "checked"; }
                  $swtich = '
                  <div class="ps-5 text-center">
                      <label class="switch">
                          <input class="" type="checkbox" id="togBtn" onClick="state_switch('.$row->id.')" '.$checked.'>
                          <div class="slider round">
                              <span class="on">ON</span>
                              <span class="off">OFF</span>
                          </div>
                      </label>
                  </div>
                  ';
                  return $swtich;
            })
            ->addColumn('actions',function($row){
                $btn =  '
                    <div class="text-lg-end align-middle edit_M">
                        <span class="px-2">
                            <a class="text-decoration-none px-1" href="'.url('/sms_hosts/edit/'.$row->id).'">
                            <i class="bi bi-gear bg-light_c round1 circul"></i>
                                <span class="px-1 text-muted">Setting</span>
                            </a>
                        </span>
                    </div>
                ';
                return $btn;
            })
            ->filter(function ($record) use ($request) {
              $input="";
              if ($request->has('search_new') && $request->search_new != "") {
                  $input=$request->get("search_new");
                  $record->where('name', 'like', '%' . $input . '%');
              }

              if ($request->has('status_filter') && $request->status_filter != "") {
                  $record->where('status', '=', $request->get('status_filter'));
              }
            })
            ->rawColumns(['is_default', 'status','actions'])
            ->make(true);
        endif;
    }

    /*public function create()
    {
        return View('admin.sms.sms_hosts_add');
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|max:255',
            'username' => 'required',
            'secret' => 'required|max:255',
            'mask' => 'required|max:255',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        } else {
            if(isset($request->default)){ $default = '1'; }else{ $default = '0'; }
            if(isset($request->status)){ $status = '1'; }else{ $status = '0'; }
            $data = [
                //'name' => $request->name,
                'username' => $request->username,
                'secret' => $request->secret,
                'mask' => $request->mask,
                'is_default' => $default,
                'status' => $status,
            ];
            $post = SmsHost::insert($data);
            $update = SmsHost::where('is_default', '1')->where('id', '!=', $post->id)->update([
                'is_default' => '0',
            ]);
            if ($post) {
                return redirect()->back()->with('success','Host added successfuly')->withInput();
            } else {
                return redirect()->back()->with('error','Somthing went wrong')->withInput();
            }
        }
    }*/

    public function edit($id)
    {
        $post = SmsHost::find($id);
        return View('admin.sms.sms_host_edit', compact('post'));
    }

    public function update(Request $request)
    {
        if(!$this->Permissions_trait('update','sms_hosts')):
            return redirect()->back()->with('error','Permission denied..')->withInput();
            //abort(403, 'Permission denied..');
            exit;
        endif;
        $validator = Validator::make($request->all(), [
            'name' => 'required|max:255',
            'username' => 'required',
            'secret' => 'required|max:255',
            'mask' => 'required|max:255',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        } else {
            if(isset($request->default)){ $default = '1'; }else{ $default = '0'; }
            if(isset($request->status)){ $status = '1'; }else{ $status = '0'; }
            if ($default == 1) {
                $status = '1';
            }
            $data = [
                //'name' => $request->name,
                'username' => $request->username,
                'secret' => $request->secret,
                'mask' => $request->mask,
                'is_default' => $default,
                'status' => $status,
            ];
            $old = SmsHost::where('id', $request->id)->first();
            $post = SmsHost::where('id', $request->id)->update($data);
            $update = SmsHost::where('is_default', '1')->where('id', '!=', $request->id)->update([
                'is_default' => '0',
            ]);
            activity('SMS Host updated')
            ->causedBy(Auth::user())
                ->performedOn(new SmsHost())
                ->withProperties(['old'  => $old, 'modified' => $data])
                ->tap(function (Activity $activity) {
                    $activity->route_link = $this->url;
                })
                ->log('SMS Host updated by ' . Auth::user()->name);
            if ($post) {
                return redirect()->back()->with('success','Host Updated successfuly')->withInput();
            } else {
                return redirect()->back()->with('error','Somthing went wrong')->withInput();
            }
        }
    }

    function status(Request $request)
    {
        if(!$this->Permissions_trait('update','email_hosts')):
            echo  json_encode(array('text' => trans('Permission denied..'), 'cls' => 'error'));
            //abort(403, 'Permission denied..');
            exit;
        endif;
        $state = getAny("status", "sms_hosts", "id", $request->id);
        if ($state == 1) {
            $update_state = '0';
        }else{
            $update_state = '1';
        }
        $post = SmsHost::find($request->id);
        $post->status = $update_state;
        $msg = $post->save();
        activity('SMS Host status Changed')
        ->causedBy(Auth::user())
            ->performedOn(new SmsHost())
            ->withProperties(['old'  => ['status' =>$state], 'modified' => ['status' => $update_state]])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('SMS Host status changed by ' . Auth::user()->name);
        if ($msg) {
          echo  json_encode(array('text' => trans('admin.Status_Changed'), 'cls' => 'success'));
        } else {
          echo  json_encode(array('text' => trans('admin.Error'), 'cls' => 'error'));
        }
    }

    function is_default(Request $request)
    {
        if(!$this->Permissions_trait('update','email_hosts')):
            echo  json_encode(array('text' => trans('Permission denied..'), 'cls' => 'error'));
            //abort(403, 'Permission denied..');
            exit;
        endif;
        $state = getAny("is_default", "sms_hosts", "id", $request->id);
        $status = getAny("status", "sms_hosts", "id", $request->id);
        if ($state == 1) {
            $update_state = '0';
        }else{
            $update_state = '1';
            $status = '1';
        }
        $post = SmsHost::find($request->id);
        $post->is_default = $update_state;
        $post->status = $status;
        $msg = $post->save();

        $update = SmsHost::where('is_default', '1')->where('id', '!=', $request->id)->update([
            'is_default' => '0',
        ]);
        activity('SMS template Default Host Changed')
        ->causedBy(Auth::user())
            ->performedOn(new SmsHost())
            ->withProperties(['old'  => ['is_default' =>$state], 'modified' => ['is_default' => $update_state]])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('SMS template Default Host changed by ' . Auth::user()->name);
        if ($msg) {
            echo  json_encode(array('text' => trans('admin.Status_Changed'), 'cls' => 'success'));
        } else {
            echo  json_encode(array('text' => trans('admin.Error'), 'cls' => 'error'));
        }
    }

    public function destroy(Request $request)
    {
        if(!$this->Permissions_trait('delete','email_hosts')):
            return ['text' => trans('Permission denied..'), 'cls' => 'error'];
            //abort(403, 'Permission denied..');
            exit;
        endif;
        //$msg = SmsHost::where('id',$request->id)->delete();
        $post = SmsHost::find($request->id);
        $post->status = '-1';
        $msg = $post->save();
        activity('SMS Host Deleted')
            ->causedBy(Auth::user())
            ->performedOn(new SmsHost())
            ->withProperties(['old'  => ['status' =>$post->status], 'modified' => ['status' => '-1']])
                ->tap(function (Activity $activity) {
                    $activity->route_link = $this->url;
                })
                ->log('Sms Host Deleted by ' . Auth::user()->name);
        if ($msg) {
            return ['text' => trans('admin.Delete_successfully'), 'cls' => 'success'];
        } else {
            return ['text' => trans('admin.Somthing_went_wrong'), 'cls' => 'error'];
        }
    }

    /*sms templates code start from here*/
    public function sms_template(Request $request)
    {
        if (!$this->Permissions_trait('view', $this->url)) :
            abort(403, 'Permission denied..');
        endif;
        if ($request->ajax()) :
            $record = SmsTemplate::select('*')->where('status', '!=', '-1')->orderBy('id', 'desc');
            return Datatables::of($record)
            ->setRowId(function ($row) {
                return $row->id;
            })
            ->addColumn('is_default',function ($row) {
                $checked = "";
                  if ($row->is_default == 1) { $checked = "checked"; }
                  $swtich = '
                  <div class="ps-5 text-center">
                      <label class="switch">
                          <input class="" type="checkbox" id="togBtn" onClick="temp_is_default('.$row->id.')" '.$checked.'>
                          <div class="slider round">
                              <span class="on">ON</span>
                              <span class="off">OFF</span>
                          </div>
                      </label>
                  </div>
                  ';
                  return $swtich;
            })
            ->addColumn('status',function ($row) {
                $checked = "";
                  if ($row->status == 1) { $checked = "checked"; }
                  $swtich = '
                  <div class="ps-5 text-center">
                      <label class="switch">
                          <input class="" type="checkbox" id="togBtn" onClick="temp_state_switch('.$row->id.')" '.$checked.'>
                          <div class="slider round">
                              <span class="on">ON</span>
                              <span class="off">OFF</span>
                          </div>
                      </label>
                  </div>
                  ';
                  return $swtich;
            })
            ->addColumn('actions',function($row){
                $btn =  '
                <div class="text-center">
                    <span class="px-2">
                        <a class="text-decoration-none px-1" href="'.url('/sms_template/edit_temp/'.$row->id).'">
                            <span class="edit_icon">
                                <i class="bi bi-pen"></i>
                            </span>
                            <span class="px-1 e-text">Edit</span>
                        </a>
                    </span>
                    <span>
                        <a class="text-decoration-none px-1" onClick="temp_destroy('.$row->id.')">
                            <span class="delete_icon fw-bold"><i class="bi bi-backspace"></i></span>
                            <span class="px-1 tcancel e-text">Delete</span>
                        </a>
                    </span>
                </div>
                ';
                return $btn;
            })
            ->filter(function ($record) use ($request) {
              $input="";
              if ($request->has('search_new') && $request->search_new != "") {
                  $input=$request->get("search_new");
                  $record->where('name', 'like', '%' . $input . '%');
              }

              if ($request->has('status_filter') && $request->status_filter != "") {
                  $record->where('status', '=', $request->get('status_filter'));
              }
            })
            ->rawColumns(['name', 'is_default', 'status','actions'])
            ->make(true);
        endif;
        activity('SMS Templates Page Visited')
           ->causedBy(Auth::user())
            ->performedOn(new SmsTemplate())
            // ->withProperties(['old'  => [], 'modified'=>$data])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('SMS Templates Page visited by ' . Auth::user()->name);
        return view('admin/sms.sms_template');
    }

    /*public function add_temp()
    {
        return View('admin.sms.sms_template_add');
    }

    public function save_temp(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|max:255',
            'title' => 'required|max:255',
            'text' => 'required|max:255',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        } else {
            $data = [
                //'name' => $request->name,
                'title' => $request->title,
                'text' => $request->text,
            ];
            $post = SmsTemplate::insert($data);
            if ($post) {
                return redirect()->back()->with('success','Added successfuly')->withInput();
            } else {
                return redirect()->back()->with('error','Somthing went wrong')->withInput();
            }
        }
    }*/

    public function edit_temp($id)
    {
        $post = SmsTemplate::find($id);
        return View('admin.sms.sms_template_edit', compact('post'));
    }

    public function update_temp(Request $request)
    {
        if(!$this->Permissions_trait('update','sms_template')):
            return redirect()->back()->with('error','Permission denied..')->withInput();
            //abort(403, 'Permission denied..');
            exit;
        endif;
        $validator = Validator::make($request->all(), [
            'name' => 'required|max:255',
            'title' => 'required|max:255',
            'text' => 'required|max:255',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        } else {
            $data = [
                //'name' => $request->name,
                'title' => $request->title,
                'text' => $request->text,
            ];
            $old = SmsTemplate::where('id', $request->id)->first();
            $post = SmsTemplate::where('id', $request->id)->update($data);
            activity('SMS Template updated')
            ->causedBy(Auth::user())
                ->performedOn(new SmsTemplate())
                ->withProperties(['old'  => $old, 'modified' => $data])
                ->tap(function (Activity $activity) {
                    $activity->route_link = $this->url;
                })
                ->log('SMS Template updated by ' . Auth::user()->name);
            if ($post) {
                return redirect()->back()->with('success','Host Updated successfuly')->withInput();
            } else {
                return redirect()->back()->with('error','Somthing went wrong')->withInput();
            }
        }
    }

    function temp_status(Request $request)
    {
        if(!$this->Permissions_trait('update','sms_template')):
            echo  json_encode(array('text' => trans('Permission denied..'), 'cls' => 'error'));
            //abort(403, 'Permission denied..');
            exit;
        endif;
        $state = getAny("status", "sms_templates", "id", $request->id);
        if ($state == 1) {
            $update_state = '0';
        }else{
            $update_state = '1';
        }
        $post = SmsTemplate::find($request->id);
        $post->status = $update_state;
        $msg = $post->save();
        activity('SMS Template status Changed')
        ->causedBy(Auth::user())
            ->performedOn(new SmsTemplate())
            ->withProperties(['old'  => ['status' =>$state], 'modified' => ['status' => $update_state]])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('SMS Template status changed by ' . Auth::user()->name);
        if ($msg) {
          echo  json_encode(array('text' => trans('admin.Status_Changed'), 'cls' => 'success'));
        } else {
          echo  json_encode(array('text' => trans('admin.Error'), 'cls' => 'error'));
        }
    }

    function temp_is_default(Request $request)
    {
        if(!$this->Permissions_trait('update','sms_template')):
            echo  json_encode(array('text' => trans('Permission denied..'), 'cls' => 'error'));
            //abort(403, 'Permission denied..');
            exit;
        endif;
        $state = getAny("is_default", "sms_templates", "id", $request->id);
        if ($state == 1) {
            $update_state = 0;
        }else{
            $update_state = 1;
        }
        $post = SmsTemplate::find($request->id);
        $post->is_default = $update_state;
        $msg = $post->save();

        $update = SmsTemplate::where('is_default', 1)->where('id', '!=', $request->id)->update([
            'is_default' => '0',
        ]);
        activity('SMS Template Changed')
        ->causedBy(Auth::user())
            ->performedOn(new EmailHost())
            ->withProperties(['old'  => ['is_default' =>$state], 'modified' => ['is_default' => $update_state]])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('SMS Template changed by ' . Auth::user()->name);
        if ($msg) {
            echo  json_encode(array('text' => trans('admin.Status_Changed'), 'cls' => 'success'));
        } else {
            echo  json_encode(array('text' => trans('admin.Error'), 'cls' => 'error'));
        }
    }

    public function temp_destroy(Request $request)
    {
        if(!$this->Permissions_trait('delete','sms_template')):
            return ['text' => trans('Permission denied..'), 'cls' => 'error'];
            //abort(403, 'Permission denied..');
            exit;
        endif;
        //$msg = SmsTemplate::where('id',$request->id)->delete();
        $post = SmsTemplate::find($request->id);
        $post->status = '-1';
        $msg = $post->save();
        activity('SMS Template data Deleted')
            ->causedBy(Auth::user())
            ->performedOn(new EmailHost())
            ->withProperties(['old'  => ['status' =>$post->status], 'modified' => ['status' => '-1']])
                ->tap(function (Activity $activity) {
                    $activity->route_link = $this->url;
                })
                ->log('SMS Template data Deleted by ' . Auth::user()->name);
        if ($msg) {
            return ['text' => trans('admin.Delete_successfully'), 'cls' => 'success'];
        } else {
            return ['text' => trans('admin.Somthing_went_wrong'), 'cls' => 'error'];
        }
    }

    /*sendig sms*/
    public function sms_index(Request $request){
        if (!$this->Permissions_trait('view', $this->url)) :
            abort(403, 'Permission denied..');
        endif;
        if ($request->ajax()) {
            $data = User::select('*')->where('type','!=','admin')->where('status','1')->orderBy('id', 'desc');
            return Datatables::of($data)
            ->addIndexColumn()
            ->setRowId(function ($row) { return $row->id; })
            ->addColumn('id', function($row){
              $btn = '
                <label class="container1 p-0">
                  <input class="chk sub-check" onchange="counter();" type="checkbox" value="'.$row->id.'" name="chk[]" id="chk[]" />
                  <span class="checkmark"></span>
                </label>
              ';
              return $btn;
            })
            ->addColumn('name', function($row){
              
              $btn = '
                <sapn class="fw-bold text-dark">'.$row->name.'</sapn><br>
                <span>'.getUserType($row->user_type).'</span>
              ';
              return $btn;
            })
            ->filter(function ($record) use ($request) {
              if ($request->has('search')) {
                $record->where('name', 'like', "%" . $request->get('search')['value'] . "%");
              }

              if ($request->has('user_filter') && $request->user_filter != "") {
                  $record->where('user_type', '=', $request->get('user_filter'));
              }

              if ($request->has('locale_filter') && $request->locale_filter != "") {
                  $record->where('locale', '=', $request->get('locale_filter'));
              }

            })
            ->rawColumns(['id','name'])
            ->make(true);
        }
       
        return view('admin/sms.send_sms');
    }

    public function send_sms(Request $request)
    {
          if(isset($request->uid) && !empty($request->uid)){
          $template = SmsTemplate::where('id', $request->template)->first();
          if (isset($request->hosts) && !empty($request->hosts)) {
            $host = SmsHost::where('id', $request->hosts)->first();
          } else{
            $host = SmsHost::where('is_default', '1')->first();
          }
          /*host setting*/

          if (!empty($request->title) && !empty($request->text)) {
            $title = trim($request->title);
            $message = trim($request->text);

            $uidAry=explode(",",$request->uid);
            for($i=0; $i<count($uidAry); $i++){
                try{
                    $username = getAny('name', 'users', 'id', $uidAry[$i]);
                    $mobile = getAny('mobile', 'users', 'id', $uidAry[$i]);
                    $params = explode(',', $template->params);
                    foreach ($params as $value) {
                        $message = str_replace($value, $username, $message);
                    }
                    /*mobile sms sending api*/
                    if ($host->slug == "malath_sms_api") {
                        $DTT_SMS    = new Malath_SMS($host->username, $host->secret, 'UTF-8');
                        $Credits    = $DTT_SMS->GetCredits();
                        $SenderName = $DTT_SMS->GetSenders();
                        $CheckUser  = $DTT_SMS->CheckUserPassword();
                        $SmS_Msg    = $message;
                        $Originator = $host->mask;
                        $Send = $DTT_SMS->Send_SMS($mobile, $Originator, $SmS_Msg, $CheckUser);
                    }
                    $msg = 'Message has been send';
                }catch(Exception $ex){
                    $msg = trans('admin.Connection_Fail');
                }
            }
                activity('SMS Send')
                ->causedBy(Auth::user())
                ->tap(function (Activity $activity) {
                    $activity->route_link = $this->url;
                })
                ->log('SMS Send by ' . Auth::user()->name.' to '.$data['email']);
            echo json_encode(array('text' => $msg, 'cls' => 'success'));
          } else{
            echo json_encode(array('text' => trans('admin.write_somethings'), 'cls' => 'warn'));
          }
        } else{
            echo json_encode(array('text' => trans('admin.Select_user'), 'cls' => 'info'));
        }
    }

    /*get templates*/
    public function get_template($id)
    {
        $data = SmsTemplate::find($id);
        echo json_encode(array('title' => $data->title, 'params' => $data->params, 'text' => $data->text));
    }
}
