<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Response;
use DataTables;
use App\Models\Admin\Menu;
use Illuminate\Http\Request;
use App\Models\Admin\Role as RoleModel;
use App\Traits\Permissions_trait;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Role;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Route;
use Spatie\Activitylog\Models\Activity;
use Spatie\Permission\Models\Permission;
use App\Models\Admin\Permission as PermissionModel;

class RoleController extends Controller
{

    var $url;
    var $user;
    use Permissions_trait;
    public function __construct()
    {
        $this->middleware('auth');
        $this->url = request()->path();
        $this->user = Auth::user();
    }
    public function index(Request $request)
    {
        if (!$this->Permissions_trait('view', $this->url)) :
            abort(403, 'Permission denied..');
        endif;
        if ($request->ajax()) {
            $data = RoleModel::select('*');
            return Datatables::of($data)
            ->addIndexColumn()
            ->setRowId(function ($row) {
                 return $row->id;
                })
            ->addColumn('action', function($row){
                $btn = "";
                if($this->Permissions_trait('update',$this->url)):
                    $btn = '<a type="button" class="btn btn-outline-secondary btn-xs" onClick="edit_user('.$row->id.');"><i class="bi-pencil-square" style="font-size:16;line-height:0;"></i> '.trans('admin.edit_role'). '</a>';

                    $btn .= '<a type="button" class="btn btn-outline-primary btn-xs" onClick="assign_permission(' . $row->id . ');"><i class="bi-pencil-square" style="font-size:16;line-height:0;"></i> ' . trans('admin.assign_permssions') . '</a>';
                endif;
                return $btn;
            })
            ->rawColumns(['action'])
            ->make(true);
        }
        activity('User Roles Page visited')
        ->causedBy(Auth::user())
        ->performedOn(new role())
            // ->withProperties(['old'  => [PortfolioType::find($request->id)], 'modified' => $data])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('User Roles visited by ' . Auth::user()->name);
        return view('admin.roles.manage_roles');
    }

    public function addModel(){
        return view('admin.roles.role_add');
    }

    public function save(Request $request){
        $data = ['name' => $request->lbl_en, 'lbl_ar' => $request->lbl_ar, 'guard_name' => 'web'];
        $role = RoleModel::updateOrCreate($data);
        activity('New User Role added')
        ->causedBy(Auth::user())
        ->performedOn(new Role())
            ->withProperties(['old'  => [Role::find($request->id)], 'modified' => $data])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('New User Role added by ' . Auth::user()->name);
        return ['text' => trans('admin.saved_successfully'), 'cls' => 'success'];
        // if (checkAccess('r_add')) {
        //     if (RoleModel::where('lbl_en', $request->lbl_en)->exists()) {
        //       echo  json_encode(array('text'=> trans('admin.already_exists'),'cls'=>'warn'));
        //     } else{
        //         $post = new Role;
        //         $post->lbl_en = strip_tags($request->lbl_en);
        //         $post->lbl_ar = strip_tags($request->lbl_ar);
        //         $msg = $post->save();
        //         $post_per = new Permission;
        //         $post_per->role_id = $post->id;
        //         $post_per->r_view = $request->view_status;
        //         $post_per->r_add = $request->add_status;
        //         $post_per->r_edit = $request->edit_status;
        //         $post_per->r_delete = $request->delete_status;
        //         $msg = $post_per->save();
        //         if ($msg) {
        //           echo  json_encode(array('text'=> trans('admin.Saved_successfully'),'cls'=>'success'));
        //         } else {
        //           echo  json_encode(array('text'=> trans('admin.Not_Saved'),'cls'=>'error'));
        //         }
        //     }
        // } else{
        //   echo  json_encode(array('text' =>  trans('admin.You_have_no_permission'), 'cls' => 'error'));
        // }

    }

    function editModel(Request $request){
        $role = RoleModel::find($request->id);
        // $permissions = PermissionModel::where('role_id',$request->id)->get();
        activity('User Role Edit Page visited')
        ->causedBy(Auth::user())
        ->performedOn(new Role())
            // ->withProperties(['old'  => [PortfolioType::find($request->id)], 'modified' => $data])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('User Role data Edited by ' . Auth::user()->name);
        return view('admin.roles.role_edit',compact('role'));
    }

    function update(Request $request){
        $data = ['name' => $request->lbl_en, 'lbl_ar' => $request->lbl_ar, 'guard_name' => 'web'];
        activity('User Role updated')
        ->causedBy(Auth::user())
        ->performedOn(new Role())
            ->withProperties(['old'  => [Role::find($request->id)], 'modified' => $data])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('User Role data updated by ' . Auth::user()->name);
        $role = RoleModel::where('id',$request->id)->update($data);
        return ['text' => trans('admin.saved_successfully'), 'cls' => 'success'];
        // if (checkAccess('r_edit')) {
        //     $post = RoleModel::find($request->id);
        //     $post->lbl_en = strip_tags($request->lbl_en);
        //     $post->lbl_ar = strip_tags($request->lbl_ar);
        //     $msg = $post->save();
        //     $post_per = Permission::find($request->per_id);
        //     $post_per->r_view = $request->view_status;
        //     $post_per->r_add = $request->add_status;
        //     $post_per->r_edit = $request->edit_status;
        //     $post_per->r_delete = $request->delete_status;
        //     $msg = $post_per->save();
        //     if ($msg) {
        //         echo  json_encode(array('text'=> trans('admin.Updated_successfully'),'cls'=>'success'));
        //     } else {
        //         echo  json_encode(array('text'=> trans('admin.not_saved'),'cls'=>'error'));
        //     }
        // } else{
        //   echo  json_encode(array('text' =>  trans('admin.You_have_no_permission'), 'cls' => 'error'));
        // }

    }

    function destroy(Request $request){

        if (checkAccess('r_delete')) {

            activity('User role Deleted')
            ->causedBy(Auth::user())
            ->performedOn(new Role())
            ->withProperties(['old'  => [Role::find($request->id)], 'modified' => [] ])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('User Role deleted by ' . Auth::user()->name);
            $msg = RoleModel::where('id', $request->id)->delete();
            $msg = PermissionModel::where('role_id',$request->id)->delete();
            if ($msg) {

                echo  json_encode(array('text'=> trans('admin.Delete_successfully'),'cls'=>'success'));
            } else {
                echo  json_encode(array('text'=> trans('admin.not_deleted'),'cls'=>'error'));
            }
        } else{
          echo  json_encode(array('text' =>  trans('admin.You_have_no_permission'), 'cls' => 'error'));
        }
    }

    function assign_permissions($role_id)
    {
        $role = Role::find($role_id);
        $menus = Menu::orderBY('id','DESC')->get();

        activity('Permission Page Visited')
        ->causedBy(Auth::user())
            ->performedOn(new Role())
            // ->withProperties(['old'  => [Role::find($request->id)], 'modified' => []])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('Permission Page Visited for Role "'.$role->name.'" Type data updated by ' . Auth::user()->name);

        $permissions = Role::findById($role_id)->permissions->pluck('name');

        foreach ($menus as $key => $value) {
                $menus[$key]->sub_menu = Menu::where('parent_id','=',$value->id)->get();
        }
        $data = [
            'role' => $role,
            'menus' => $menus,
            'permissions' => json_decode(json_encode($permissions),true),
            ];
        return  view('admin.roles.permission_view')->with($data);
    }

    function assign_permission_to_role(Request $request)
    {
        $role = Role::find($request->role_id);
        if(!$request->perm):
            return redirect()->back()->with('message', 'Successfully added.');
            die;
        endif;
        DB::table('role_has_permissions')->where('role_id', $request->role_id)->delete();
        foreach ($request->perm as $key => $value):
            $permission =  Permission::firstOrCreate(['name' => $value]);
            $role->givePermissionTo($permission);
        endforeach;

        activity('Permissions updated')
        ->causedBy(Auth::user())
            ->performedOn(new Role())
            // ->withProperties(['old'  => [Role::find($request->id)], 'modified' => []])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('Permission updated by ' . Auth::user()->name.' for '.$role->name);
        return redirect()->back()->with('message','Successfully added.');
    }
}
