<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Traits\Permissions_trait;
use App\Models\Admin\User;
use App\Models\Admin\Favourite_menu;
use App\Models\Admin\Menu;
use Spatie\Activitylog\Models\Activity;
use Response;


class ProfileController extends Controller
{
    use Permissions_trait;
    var $url;
    public function __construct()
    {
        $this->middleware('auth');
        $this->url = request()->path();
    }
  
    public function index(Request $request)
    {
        $user = User::find(Auth::user()->id);
        $favMenus = Favourite_menu::whereUser_id(Auth::user()->id)->pluck('menu_id');
        $menus = Menu::where('parent_id','>',0)->whereNotIn('id',$favMenus)->orderBy('order_by')->get();
        activity('Profile page visited')
        ->causedBy(Auth::user())
         ->performedOn(new User())
         // ->withProperties(['old'  => [], 'modified'=>$data])
         ->tap(function (Activity $activity) {
             $activity->route_link = $this->url;
         })
         ->log('Profile page visited by ' . Auth::user()->name);
        return view('admin/profile.profile_manage',compact('user','menus'));
    }

    //update profile info
    function updateProfile(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'name' => 'required|max:255',
            'username' => 'required',
            'email' => 'required|email',
            'photo' => 'image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        } else {
            $photo = $request->file('photo');
            if ($photo) {
                $new_name = rand() . '.' . $photo->getClientOriginalExtension();
                $photo->move(public_path('project/profile/'), $new_name);
            } else{
                $new_name = User::find($request->id)->photo;
            }
            $data = [
                'name' => $request->name,
                'username' => $request->username,
                'email' => $request->email,
                'mobile' => $request->mobile,
                'photo' => $new_name,
            ];
            $post = User::where('id', $request->id)->update($data);
            
            if ($post) {
                return redirect()->back()->with('success','Updated successfuly')->withInput();
            } else {
                return redirect()->back()->with('error','Somthing went wrong')->withInput();
            }
        }
    }
    //end update profile info

    //update pass info
    function resetPass(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'old_password' => 'required|max:8',
            'password' => 'required|confirmed|max:8',
            'password_confirmation' => 'required|max:8',
        ]);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        } else {
            $post = User::find($request->id);
            if (Hash::check($request->old_password, $post->password)) {
            $post->password = Hash::make($request->password);
            $msg = $post->save();
            if ($msg) {
                return redirect()->back()->with('success','Password Updated successfuly')->withInput();
            } else {
                return redirect()->back()->with('error','Somthing went wrong')->withInput();
            }
            }else{
            return redirect()->back()->with('error',trans('admin.Incorrect_Old_Password'))->withInput();
            }
        }
    }
    //end update profile info

    //favourite_menu data
    function favourite_menu(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'menu_id' => 'required',
        ]);
        if ($validator->fails()) {
            return redirect()->back()->withErrors($validator)->withInput();
        } else {
            $post="";
            foreach ($request->menu_id as $value) {
                $data = [
                    'menu_id' => $value,
                    'user_id' => $request->id,
                ];
                $post = Favourite_menu::insert($data);
            }
            if ($post) {
                return redirect()->back()->with('success','Added successfuly')->withInput();
            } else {
                return redirect()->back()->with('error','Somthing went wrong')->withInput();
            }
        }
    }
    //favourite_menu data
}
