<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use Response;
use Validator;
use Illuminate\Http\Request;
use App\Models\Order;
use App\Models\Order_detail;
use App\Models\User;
use DataTables;

use App\Traits\Permissions_trait;
use Spatie\Activitylog\Models\Activity;

class OrderController extends Controller
{
  use Permissions_trait;
  var $url;
  public function __construct()
  {
      $this->middleware('auth');
      $this->url = request()->path();
  }

  public function index(Request $request)
  {
    if (!$this->Permissions_trait('view', $this->url)) :
        abort(403, 'Permission denied..');
    endif;
    if ($request->ajax()) {
      $record = Order::select('*')->orderBy('id', 'desc');
      return Datatables::of($record)
      ->addIndexColumn()
      ->setRowId(function ($row) { return $row->id; })
      ->addColumn('user_id', function($row){
          return userInfo($row->user_id);
      })
      ->addColumn('id', function($row){
          return "#".$row->id;
      })
      ->addColumn('status', function($row){
          $div = "";
          if ($row->status == 0) { 
          	$div = "<p class='bt-shap bt-gray'>Pending</p>"; 
          }
          elseif ($row->status == 1) {
          	$div = "<p class='bt-shap bg-warning'>Active</p>";
          }
          elseif ($row->status == 2) {
          	$div = "<p class='bt-shap'>Completed</p>";
          }
          elseif ($row->status == 3) {
          	$div = "<p class='bt-shap bg-danger'>Cancelled</p>";
          }
          return $div;
      })
      ->addColumn('action', function($row){
          $btn = '
          <div class="float-end">
            <span class="px-2">
                <a class="text-decoration-none px-1" href="'.url("/order_list/order_detail/".$row->id).'">
                    <span class="edit_icon">
                        <i class="bi bi-info" style="font-size: 16px;"></i>
                    </span>
                    <span class="px-1 e-text">Detail</span>
                </a>
            </span>
            </div>
          ';
          return $btn;
      })
      ->filter(function ($record) use ($request) {
      	  /*search*/
      	  $input=$user_id="";
          if ($request->has('search_new') && $request->search_new != "") {
            $input=$request->get("search_new");
            if (isset(User::where('name', 'like', '%'. $input .'%')->first()->id)) {
            	$user_id = User::where('name', 'like', '%'. $input .'%')->first()->id;
            	$record->where('user_id', 'like', '%'. $user_id .'%');
            }
            else{
            	$record->where('id', 'like', '%'. $input .'%')->orwhere('net_total', 'like', '%'. $input .'%');
            }
          }
          /*status*/       
          if ($request->has('status_filter') && $request->status_filter != "") {
            $record->where('status', '=', $request->get('status_filter'));
          }
      })
      ->rawColumns(['action','status'])
      ->make(true);
    }
    activity('Orders Page Browsed')
           ->causedBy(Auth::user())
            ->performedOn(new Order())
            // ->withProperties(['old'  => [], 'modified'=>$data])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('Orders Page visited by ' . Auth::user()->name);
    return view('admin/orders.orders');
  }

  function add()
  {
    return view('admin/orders.order_detail');
  }

  function status(Request $request)
  {
    if(!$this->Permissions_trait('update','order_list')):
            echo  json_encode(array('text' => trans('Permission denied..'), 'cls' => 'error'));
            //abort(403, 'Permission denied..');
            exit;
        endif;
    $state = getAny("status", "email_templates", "id", $request->id);
    if ($state == 1) {
        $update_state = 0;
    }else{
        $update_state = 1;
    }
    $post = Email_templates::find($request->id);
    $post->status = $update_state;
    $msg = $post->save();
    activity('Status Changed')
        ->causedBy(Auth::user())
            ->performedOn(new EmailHost())
            ->withProperties(['old'  => ['status' =>$state], 'modified' => ['status' => $update_state]])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('Status changed by ' . Auth::user()->name);
    if ($msg) {
      echo  json_encode(array('text' => trans('admin.Status_Changed'), 'cls' => 'success'));
    } else {
      echo  json_encode(array('text' => trans('admin.Error'), 'cls' => 'error'));
    }
  }

  function destroy(Request $request)
  {
    if(!$this->Permissions_trait('delete','order_list')):
            echo  json_encode(array('text' => trans('Permission denied..'), 'cls' => 'error'));
            //abort(403, 'Permission denied..');
            exit;
        endif;
    //$msg = Category::where('id', $request->id)->delete();
    $post = Email_templates::find($request->id);
    $post->status = -1;
    $msg = $post->save();
    activity('Data Deleted')
    ->causedBy(Auth::user())
    ->performedOn(new EmailHost())
    ->withProperties(['old'  => ['status' =>$post->status], 'modified' => ['status' => '-1']])
        ->tap(function (Activity $activity) {
            $activity->route_link = $this->url;
        })
        ->log('Country Deleted Created by ' . Auth::user()->name);
    if ($msg) {
      echo  json_encode(array('text' => trans('admin.Delete_successfully'), 'cls' => 'warning'));
    } else {
      echo  json_encode(array('text' => trans('admin.Error'), 'cls' => 'error'));
    }
  }
}
