<?php

namespace App\Http\Controllers\Admin;
use App\Http\Controllers\Controller;
use DataTables;
use Illuminate\Http\Request;
use App\Models\Admin\UserLoginHistory;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use App\Traits\Permissions_trait;
use Spatie\Activitylog\Models\Activity;

class LogeController extends Controller
{

    use Permissions_trait;
    var $url;
    public function __construct()
    {
        $this->middleware('auth');
        $this->url = request()->path();
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function getUserLoginLog(Request $request){
        if (!$this->Permissions_trait('view', $this->url)) :
            abort(403, 'Permission denied..');
        endif;
        if($request->ajax()):
            $data = UserLoginHistory::all()->sortByDesc("id");
            return Datatables::of($data)
                ->addIndexColumn()
                ->setRowId(function ($row) {
                    return $row->id;
                })
                ->addColumn('user', function ($row) {
                    return $row->user->name;
                })
                ->addColumn('created_at',function ($row){
                    return Carbon::parse($row->created_at)->diffForHumans();
                })
                ->make(true);
        endif;
        return view("admin.userLoginHistory.index");
    }

    public function index($fromDate=null,$toDate=null)
    {
        if (!$this->Permissions_trait('view', $this->url)) :
            abort(403, 'Permission denied..');
        endif;
        $record = Activity::where('causer_id',Auth::user()->id);
        if($fromDate):
            $record->where('created_at','>=',Date('Y-m-d H:m:i',strtotime($fromDate)));
        endif;
        if ($fromDate) :
            $record->where('created_at', '<=', Date('Y-m-d H:m:i', strtotime($toDate)));
        endif;
        $record = $record->get();

        return View('admin.logs.loges',compact('record','fromDate','toDate'));
    }

}
