<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Auth;
use Response;
use Validator;
use DataTables;
use App\Models\Admin\Countries;
use Illuminate\Http\Request;
use App\Traits\Permissions_trait;
use Spatie\Activitylog\Models\Activity;

class CountryController extends Controller
{
    use Permissions_trait;
    var $url;
    public function __construct()
    {
        $this->middleware('auth');
        $this->url = request()->path();
    }
    public function index(Request $request)
    {
        if (!$this->Permissions_trait('view', $this->url)) :
            abort(403, 'Permission denied..');
        endif;

        if ($request->ajax()) {
            $data = Countries::all()->sortByDesc("id");
            return Datatables::of($data)
            ->addIndexColumn()
            ->setRowId(function ($row) { return $row->id; })
            ->addColumn('label', function($row){
                if(Auth::user()->locale == "en"){
                    $name = $row->value_en;
                }else{
                    $name = $row->value_ar;
                }
                return $name;
            })
            ->addColumn('status', function($row){
                $checked = "";
                if ( $row->status == 1) { $checked = "checked"; }
                $swtich = '
                    <label class="switch" for="checkbox'.$row->id.'">
                        <input class="state_switch" type="checkbox" id="checkbox'.$row->id.'" value="'.$row->id.'" '.$checked.' />
                        <div class="slider round"></div>
                    </label>
                ';
                return $swtich;
            })
            ->addColumn('action', function($row){
                $btn = '
                    <button onclick="edit_category('.$row->id.');" id="edit_sub_cat" class="btn btn-warning btn-xs">'.trans('admin.Edit').'</button>
                    <button class="btn btn-xs btn-danger btn-delete" value="'.$row->id.'">'.trans('admin.Delete').'</button>
                ';
                return $btn;
            })
            ->rawColumns(['action','status'])
            ->make(true);
        }
        activity('Country Page Visited')
           ->causedBy(Auth::user())
            ->performedOn(new Countries())
            // ->withProperties(['old'  => [], 'modified'=>$data])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('Country Page visited by ' . Auth::user()->name);
        return view('admin/countries.country');
    }

  public function addModel()
  {
    //$category = Course::where('status',1)->get();
    return view('admin/countries.add_country');
  }

  public function save(Request $request)
  {
    if(!$this->Permissions_trait('insert','countries')):
        return ['text' => trans('admin.You_have_no_permission'), 'cls' => 'error'];
        exit;
    endif;
    Countries::firstOrCreate(['name_en' => $request->name ,'name_ar' => $request->name_ar]);

        activity('Country data Added')
        ->causedBy(Auth::user())
            ->performedOn(new Countries())
            ->withProperties(['old'  => [], 'modified' => ['name_en' => $request->name, 'name_ar' => $request->name_ar]])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('Country Created by ' . Auth::user()->name);
    return ['text' => trans('admin.Saved_successfully'), 'cls' => 'success'];

  }

  function editModel(Request $request)
  {
    $post = Countries::find($request->id);

        activity('Edit Country module Visited')
        ->causedBy(Auth::user())
            ->performedOn(new Countries())
            // ->withProperties(['old'  => [], 'modified' => $data])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('Edit Country Module Visited by ' . Auth::user()->name);
    return view('admin/countries.edit_country', compact('post'));
  }

  function update(Request $request)
  {
      if(!$this->Permissions_trait('update','countries')):
        return ['text' => trans('admin.You_have_no_permission'), 'cls' => 'error'];
        exit;
      endif;
        $post = Countries::find($request->id);
        $post->name_en = $request->name;
        $post->name_ar = $request->name_ar;
        $msg = $post->save();

        activity('Country Data Updated')
        ->causedBy(Auth::user())
            ->performedOn(new Countries())
            ->withProperties(['old'  => $post, 'modified' => ['name_en' => $request->name,'name_ar' => $request->name_ar]])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('Country data Updated by ' . Auth::user()->name);
        return ['text' => trans('admin.Updated_successfully'), 'cls' => 'success'];

  }

  function statusChange(Request $request)
  {
      if(!$this->Permissions_trait('update','countries')):
        return ['text' => trans('admin.You_have_no_permission'), 'cls' => 'error'];
        exit;
      endif;
        $state = Countries::find($request->id)->status;
        $updateStatus =  ($state == 1) ? '0' : '1';
        $post = Countries::find($request->id);
        $post->status = $updateStatus;
        $msg = $post->save();
        if ($msg) {
            activity('Country Status Changed')
            ->causedBy(Auth::user())
            ->performedOn(new Countries())
            ->withProperties(['old'  => ['status' =>$state], 'modified' => ['status' => $updateStatus]])
            ->tap(function (Activity $activity) {
                $activity->route_link = $this->url;
            })
            ->log('Country Status changed by ' . Auth::user()->name);
            return ['text' => trans('admin.Status_Changed'), 'cls' => 'success'];
        }
        else{
            return ['text' => trans('admin.not change'), 'cls' => 'error'];
        }
  }

  function destroy(Request $request)
  {
    if ($this->Permissions_trait('delete', 'countries')) {
      //$msg = Course::where('id', $request->id)->delete();
      $post = Countries::find($request->id);

            activity('Country name Deleted')
            ->causedBy(Auth::user())
            ->performedOn(new Countries())
            ->withProperties(['old'  => [$post], 'modified' => [] ])
                ->tap(function (Activity $activity) {
                    $activity->route_link = $this->url;
                })
                ->log('Country Deleted Created by ' . Auth::user()->name);
      if ($post->delete()) {
        echo  json_encode(array('text' => trans('admin.Delete_successfully'), 'cls' => 'warning'));
      } else {
        echo  json_encode(array('text' => trans('admin.Error'), 'cls' => 'error'));
      }
    } else{
      echo  json_encode(array('text' => trans('admin.You_have_no_permission'), 'cls' => 'error'));
    }

  }
}
