<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;

use DataTables;
use App\Traits\LoginTrait;
use Illuminate\Http\Request;
use App\Traits\Permissions_trait;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use Spatie\Activitylog\Models\Activity as ActivityModel;

class ActivityLog extends Controller
{
    use Permissions_trait,LoginTrait;
    var $url;
    public function __construct()
    {
        $this->middleware('auth');
        $this->url = request()->path();
    }
    public function index(Request $request)
    {
        // dd($this->LoginTrait());
        if (!$this->Permissions_trait('view', $this->url)) :
            abort(403, 'Permission denied..');
        endif;

        if ($request->ajax()) {
            // DB::enableQueryLog();
            if(!$request->fromDate == ""):
                $data = Login::whereBetween('created_at', [
                    date('Y-m-d', strtotime($request->fromDate)),
                    date('Y-m-d', strtotime($request->toDate)),
                ])
                ->sortByDesc("id")
                ->get();
            else:
                $data = ActivityModel::get()
                ->sortByDesc("id");

            endif;
            // dd($data);
            // dd(DB::getQueryLog());
            return Datatables::of($data)
                ->addIndexColumn()
                ->setRowId(function ($row) {
                    return $row->id;
                })
                ->addColumn('user',function($row){
                    return $row->causer->name;
                })
                ->addColumn('properties',function($row){
                    $html = "";
                    if (isset($row->properties['old']) and $row->properties['old']) :
                    $html .= "Labels : Old Data<br>";
                        foreach ($row->properties['old'] as $key => $value) {
                            if(!is_array($value)):
                                    $html .= $key . ' : <strong>' . $value . '</strong></br>';
                                endif;
                        }
                    endif;
                    if (isset($row->properties['modified']) and $row->properties['modified']) :
                    $html .= "Labels : Modified Data<br>";
                        foreach ($row->properties['modified'] as $key => $value) {
                            $html .= $key . ' : <strong>' . $value . '</strong></br>';
                        }
                    endif;
                    return $html;
                })
                ->addColumn('status', function ($row) {
                    $checked = "";
                    if ($row->c_status == 1) {
                        $checked = "checked";
                    }
                    $swtich = '
                    <label class="switch" for="checkbox' . $row->id . '">
                        <input class="state_switch" type="checkbox" id="checkbox' . $row->id . '" value="' . $row->id . '" ' . $checked . ' />
                        <div class="slider round"></div>
                    </label>
                ';
                    return $swtich;
                })
                ->addColumn('action', function ($row) {
                    $btn = "";
                    // $btn .= '<button onclick="edit_category(' . $row->id . ');" id="edit_sub_cat" class="btn btn-warning btn-xs">' . trans('admin.Edit') . '</button>';
                    // $btn .= '<button class="btn btn-xs btn-danger btn-delete" value="' . $row->id . '">' . trans('admin.Delete') . '</button>';

                    return $btn;
                })

                ->rawColumns(['action', 'status','properties'])
                ->make(true);
        }
        return view('admin/activity.index');
    }
}
